/*
 * Decompiled with CFR 0.152.
 */
package com.sonian.elasticsearch.action.zookeeper;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodesZooKeeperStatusResponse
extends NodesOperationResponse<NodeZooKeeperStatusResponse>
implements ToXContent {
    public NodesZooKeeperStatusResponse(ClusterName clusterName, NodeZooKeeperStatusResponse[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeZooKeeperStatusResponse[in.readVInt()];
        for (int i = 0; i < ((NodeZooKeeperStatusResponse[])this.nodes).length; ++i) {
            ((NodeZooKeeperStatusResponse[])this.nodes)[i] = NodeZooKeeperStatusResponse.readNodeZooKeeperStatusResponse(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeZooKeeperStatusResponse[])this.nodes).length);
        for (NodeZooKeeperStatusResponse node : (NodeZooKeeperStatusResponse[])this.nodes) {
            node.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("cluster_name", this.getClusterNameAsString());
        builder.startObject("nodes");
        for (NodeZooKeeperStatusResponse nodeInfo : (NodeZooKeeperStatusResponse[])this.nodes) {
            builder.startObject(nodeInfo.getNode().id(), XContentBuilder.FieldCaseConversion.NONE);
            nodeInfo.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static class NodeZooKeeperStatusResponse
    extends NodeOperationResponse
    implements ToXContent {
        boolean enabled = false;
        boolean connected = false;

        NodeZooKeeperStatusResponse() {
        }

        public NodeZooKeeperStatusResponse(DiscoveryNode node, boolean enabled, boolean connected) {
            super(node);
            this.enabled = enabled;
            this.connected = connected;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean connected() {
            return this.connected;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.enabled = in.readBoolean();
            this.connected = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.enabled);
            out.writeBoolean(this.connected);
        }

        public static NodeZooKeeperStatusResponse readNodeZooKeeperStatusResponse(StreamInput in) throws IOException {
            NodeZooKeeperStatusResponse res = new NodeZooKeeperStatusResponse();
            res.readFrom(in);
            return res;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("name", this.getNode().name());
            builder.field("enabled", this.enabled());
            builder.field("connected", this.connected());
            return builder;
        }
    }
}

