/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.internal.readiness.ReadinessWatcher;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class EndpointsOperationsImpl
extends HasMetadataOperation<Endpoints, EndpointsList, DoneableEndpoints, ClientResource<Endpoints, DoneableEndpoints>> {
    public EndpointsOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, true, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public EndpointsOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Endpoints item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "endpoints", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public Endpoints waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        Endpoints endpoints = (Endpoints)this.get();
        if (endpoints == null) {
            throw new IllegalArgumentException("Endpoints with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        if (Readiness.isReady((HasMetadata)endpoints)) {
            return endpoints;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ReadinessWatcher watcher = new ReadinessWatcher(latch);
        try (Watch watch = this.watch(watcher);){
            if (latch.await(amount, timeUnit)) {
                Endpoints endpoints2 = (Endpoints)this.get();
                return endpoints2;
            }
        }
        throw new KubernetesClientTimeoutException(endpoints.getKind(), this.getName(), this.getNamespace(), amount, timeUnit);
    }
}

