/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.cloud.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.Closeable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;

public class KubernetesAPIServiceImpl
extends AbstractComponent
implements KubernetesAPIService,
Closeable {
    private final String namespace;
    private final String serviceName;
    private KubernetesClient client;

    @Override
    public Endpoints endpoints() {
        this.logger.debug("get endpoints for service {}, namespace {}", (Object)this.serviceName, (Object)this.namespace);
        return (Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.client().endpoints().inNamespace(this.namespace)).withName(this.serviceName)).get();
    }

    public KubernetesAPIServiceImpl(Settings settings) {
        super(settings);
        this.namespace = (String)NAME_SPACE_SETTING.get(settings);
        this.serviceName = (String)SERVICE_NAME_SETTING.get(settings);
    }

    public synchronized KubernetesClient client() {
        if (this.client == null) {
            this.client = new DefaultKubernetesClient();
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

