/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIServiceImpl;
import io.fabric8.elasticsearch.discovery.kubernetes.KubernetesUnicastHostsProvider;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class KubernetesDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    public static final String KUBERNETES = "kubernetes";
    private static Logger logger = Loggers.getLogger(KubernetesDiscoveryPlugin.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private final Settings settings;
    private final SetOnce<KubernetesAPIServiceImpl> kubernetesAPIService = new SetOnce();

    public KubernetesDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("Starting Kubernetes discovery plugin...");
    }

    public Map<String, Supplier<Discovery>> getDiscoveryTypes(ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService, UnicastHostsProvider hostsProvider) {
        return Collections.singletonMap(KUBERNETES, () -> new ZenDiscovery(this.settings, threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider));
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(KUBERNETES, () -> {
            this.kubernetesAPIService.set((Object)new KubernetesAPIServiceImpl(this.settings));
            return new KubernetesUnicastHostsProvider(this.settings, (KubernetesAPIService)this.kubernetesAPIService.get(), transportService, networkService);
        });
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(KubernetesAPIService.NAME_SPACE_SETTING, KubernetesAPIService.SERVICE_NAME_SETTING, KubernetesAPIService.REFRESH_SETTING, KubernetesAPIService.RETRY_SETTING, KubernetesAPIService.MAX_WAIT_SETTING);
    }

    public Settings additionalSettings() {
        String discoveryType = (String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(this.settings);
        if (discoveryType.equals(KUBERNETES)) {
            deprecationLogger.deprecated("Using " + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + " setting to set hosts provider is deprecated. Set \"" + DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey() + ": " + KUBERNETES + "\" instead", new Object[0]);
            if (!DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.exists(this.settings)) {
                return Settings.builder().put(DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey(), KUBERNETES).build();
            }
        }
        return Settings.EMPTY;
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
    }
}

