/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIServiceImpl;
import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesModule;
import io.fabric8.elasticsearch.discovery.kubernetes.KubernetesUnicastHostsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;

public class KubernetesDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    public static final String KUBERNETES = "kubernetes";
    private static Logger logger = Loggers.getLogger(KubernetesDiscoveryPlugin.class);
    private final Settings settings;
    private final SetOnce<KubernetesAPIServiceImpl> kubernetesAPIService = new SetOnce();

    public KubernetesDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("Starting kubernetes discovery plugin...");
    }

    public void onModule(DiscoveryModule discoveryModule) {
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, logger)) {
            logger.trace("Adding {} discovery type", (Object)KUBERNETES);
            discoveryModule.addDiscoveryType(KUBERNETES, ZenDiscovery.class);
            discoveryModule.addUnicastHostProvider(KUBERNETES, KubernetesUnicastHostsProvider.class);
        }
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, logger)) {
            modules.add((Module)new KubernetesModule(this.settings));
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        logger.debug("Register kubernetes discovery service");
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, logger)) {
            services.add(KubernetesModule.getKubernetesServiceImpl());
        }
        return services;
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(KubernetesAPIService.NAME_SPACE_SETTING, KubernetesAPIService.SERVICE_NAME_SETTING, KubernetesAPIService.REFRESH_SETTING, KubernetesAPIService.RETRY_SETTING, KubernetesAPIService.MAX_WAIT_SETTING);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.kubernetesAPIService.get()});
    }

    public static boolean isDiscoveryAlive(Settings settings, Logger logger) {
        if (!KUBERNETES.equalsIgnoreCase((String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(settings))) {
            logger.debug("discovery.type not set to {}", (Object)KUBERNETES);
            return false;
        }
        if (KubernetesDiscoveryPlugin.isDefined(settings, KubernetesAPIService.NAME_SPACE_SETTING) && KubernetesDiscoveryPlugin.isDefined(settings, KubernetesAPIService.SERVICE_NAME_SETTING)) {
            logger.trace("All required properties for Kubernetes discovery are set!");
            return true;
        }
        logger.debug("One or more Kubernetes discovery settings are missing. Check elasticsearch.yml file. Should have [{}] and [{}].", (Object)KubernetesAPIService.NAME_SPACE_SETTING.getKey(), (Object)KubernetesAPIService.SERVICE_NAME_SETTING.getKey());
        return false;
    }

    private static boolean isDefined(Settings settings, Setting<String> property) throws ElasticsearchException {
        return property.exists(settings) && Strings.hasText((String)((String)property.get(settings)));
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
    }
}

