/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class KubernetesUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final String namespace;
    private final String serviceName;
    private final TimeValue refreshInterval;
    private final KubernetesAPIService kubernetesAPIService;
    private TransportService transportService;
    private NetworkService networkService;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public KubernetesUnicastHostsProvider(Settings settings, KubernetesAPIService kubernetesAPIService, TransportService transportService, NetworkService networkService) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.kubernetesAPIService = kubernetesAPIService;
        this.refreshInterval = (TimeValue)KubernetesAPIService.REFRESH_SETTING.get(settings);
        this.namespace = (String)KubernetesAPIService.NAME_SPACE_SETTING.get(settings);
        this.serviceName = (String)KubernetesAPIService.SERVICE_NAME_SETTING.get(settings);
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        final ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                result.addAll(KubernetesUnicastHostsProvider.this.readNodes());
                return null;
            }
        });
        return result;
    }

    private List<DiscoveryNode> readNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                this.logger.trace("using cache to retrieve node list");
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API");
        this.cachedDiscoNodes = new ArrayList<DiscoveryNode>();
        String tmpIPAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddresses(null);
            if (inetAddress != null) {
                tmpIPAddress = NetworkAddress.format((InetAddress)inetAddress);
            }
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        String ipAddress = tmpIPAddress;
        try {
            Endpoints endpoints = this.kubernetesAPIService.endpoints();
            if (endpoints == null || endpoints.getSubsets() == null || endpoints.getSubsets().isEmpty()) {
                this.logger.warn("no endpoints found for service [{}], namespace [{}].", (Object)this.serviceName, (Object)this.namespace);
                return this.cachedDiscoNodes;
            }
            endpoints.getSubsets().stream().forEach(endpointSubset -> endpointSubset.getAddresses().stream().forEach(address -> {
                block5: {
                    String ip = address.getIp();
                    try {
                        InetAddress endpointAddress = InetAddress.getByName(ip);
                        String formattedEndpointAddress = NetworkAddress.format((InetAddress)endpointAddress);
                        try {
                            if (formattedEndpointAddress.equals(ipAddress)) {
                                this.logger.trace("current node found. Ignoring {}", (Object)ipAddress);
                                break block5;
                            }
                            endpointSubset.getPorts().stream().forEach(port -> {
                                try {
                                    TransportAddress[] addresses;
                                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(formattedEndpointAddress + ":" + port.getPort(), 1)) {
                                        this.logger.info("adding endpoint {}, transport_address {}", (Object)endpointAddress, (Object)transportAddress);
                                        this.cachedDiscoNodes.add(new DiscoveryNode("#cloud-" + endpointAddress + "-" + 0, transportAddress, Version.CURRENT.minimumCompatibilityVersion()));
                                    }
                                }
                                catch (Exception e) {
                                    this.logger.warn("failed to add endpoint {}", (Object)e, (Object)endpointAddress);
                                }
                            });
                        }
                        catch (Exception e) {
                            this.logger.warn("failed to add endpoint {}", (Object)e, (Object)endpointAddress);
                        }
                    }
                    catch (UnknownHostException e) {
                        this.logger.warn("Ignoring invalid endpoint IP address: {}", (Object)e, (Object)ip);
                    }
                }
            }));
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery: {}", (Object)e, (Object)e.getMessage());
        }
        this.logger.debug("{} node(s) added", (Object)this.cachedDiscoNodes.size());
        this.logger.debug("using dynamic discovery nodes {}", this.cachedDiscoNodes);
        return this.cachedDiscoNodes;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

