/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import io.fabric8.openshift.api.model.EditableBuildRequest;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildRequestBuilder
extends BuildRequestFluentImpl<BuildRequestBuilder>
implements VisitableBuilder<BuildRequest, BuildRequestBuilder> {
    BuildRequestFluent<?> fluent;

    public BuildRequestBuilder() {
        this(new BuildRequest());
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent) {
        this(fluent, new BuildRequest());
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent, BuildRequest instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withBinary(instance.getBinary());
        fluent.withEnv(instance.getEnv());
        fluent.withFrom(instance.getFrom());
        fluent.withKind(instance.getKind());
        fluent.withLastVersion(instance.getLastVersion());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRevision(instance.getRevision());
        fluent.withTriggeredByImage(instance.getTriggeredByImage());
    }

    public BuildRequestBuilder(BuildRequest instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withBinary(instance.getBinary());
        this.withEnv(instance.getEnv());
        this.withFrom(instance.getFrom());
        this.withKind(instance.getKind());
        this.withLastVersion(instance.getLastVersion());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withTriggeredByImage(instance.getTriggeredByImage());
    }

    @Override
    public EditableBuildRequest build() {
        EditableBuildRequest buildable = new EditableBuildRequest(this.fluent.getApiVersion(), this.fluent.getBinary(), this.fluent.getEnv(), this.fluent.getFrom(), this.fluent.getKind(), this.fluent.getLastVersion(), this.fluent.getMetadata(), this.fluent.getRevision(), this.fluent.getTriggeredByImage());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildRequestBuilder that = (BuildRequestBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

