/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.cloud.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class KubernetesAPIServiceImpl
extends AbstractLifecycleComponent<KubernetesAPIService>
implements KubernetesAPIService {
    private final String namespace;
    private final String serviceName;
    private final String podLabel;
    private KubernetesClient client;

    @Override
    public Endpoints endpoints() {
        this.logger.debug("get endpoints for service {}, namespace {}", new Object[]{this.serviceName, this.namespace});
        return (Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.client().endpoints().inNamespace(this.namespace)).withName(this.serviceName)).get();
    }

    @Override
    public List<Pod> pods() {
        this.logger.debug("get endpoints with pod label {}, namespace {}", new Object[]{this.podLabel, this.namespace});
        String[] l = this.podLabel.split("=");
        return ((PodList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)this.client().pods().inNamespace(this.namespace)).withLabel(l[0], l[1])).list()).getItems();
    }

    @Inject
    public KubernetesAPIServiceImpl(Settings settings) {
        super(settings);
        this.namespace = settings.get("cloud.kubernetes.namespace");
        this.serviceName = settings.get("cloud.kubernetes.service");
        this.podLabel = settings.get("cloud.kubernetes.pod_label");
    }

    public synchronized KubernetesClient client() {
        if (this.client == null) {
            this.client = new DefaultKubernetesClient();
        }
        return this.client;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void doClose() throws ElasticsearchException {
    }
}

