/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableScaleSpec;
import io.fabric8.kubernetes.api.model.extensions.ScaleSpec;
import io.fabric8.kubernetes.api.model.extensions.ScaleSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ScaleSpecBuilder
extends ScaleSpecFluentImpl<ScaleSpecBuilder>
implements VisitableBuilder<ScaleSpec, ScaleSpecBuilder> {
    ScaleSpecFluent<?> fluent;

    public ScaleSpecBuilder() {
        this(new ScaleSpec());
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent) {
        this(fluent, new ScaleSpec());
    }

    public ScaleSpecBuilder(ScaleSpecFluent<?> fluent, ScaleSpec instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
    }

    public ScaleSpecBuilder(ScaleSpec instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
    }

    @Override
    public EditableScaleSpec build() {
        EditableScaleSpec buildable = new EditableScaleSpec(this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleSpecBuilder that = (ScaleSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

