/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ComponentCondition;
import io.fabric8.kubernetes.api.model.ComponentConditionFluent;
import io.fabric8.kubernetes.api.model.ComponentConditionFluentImpl;
import io.fabric8.kubernetes.api.model.EditableComponentCondition;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ComponentConditionBuilder
extends ComponentConditionFluentImpl<ComponentConditionBuilder>
implements VisitableBuilder<ComponentCondition, ComponentConditionBuilder> {
    ComponentConditionFluent<?> fluent;

    public ComponentConditionBuilder() {
        this(new ComponentCondition());
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent) {
        this(fluent, new ComponentCondition());
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent, ComponentCondition instance) {
        this.fluent = fluent;
        fluent.withError(instance.getError());
        fluent.withMessage(instance.getMessage());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
    }

    public ComponentConditionBuilder(ComponentCondition instance) {
        this.fluent = this;
        this.withError(instance.getError());
        this.withMessage(instance.getMessage());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
    }

    @Override
    public EditableComponentCondition build() {
        EditableComponentCondition buildable = new EditableComponentCondition(this.fluent.getError(), this.fluent.getMessage(), this.fluent.getStatus(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentConditionBuilder that = (ComponentConditionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

