/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class KubernetesUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final Version version;
    private final String namespace;
    private final String serviceName;
    private final String podLabel;
    private final int podPort;
    private final TimeValue refreshInterval;
    private final KubernetesAPIService kubernetesAPIService;
    private TransportService transportService;
    private NetworkService networkService;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public KubernetesUnicastHostsProvider(Settings settings, KubernetesAPIService kubernetesAPIService, TransportService transportService, NetworkService networkService, Version version) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.kubernetesAPIService = kubernetesAPIService;
        this.version = version;
        this.refreshInterval = settings.getAsTime("cloud.kubernetes.refresh_interval", TimeValue.timeValueSeconds((long)0L));
        this.namespace = settings.get("cloud.kubernetes.namespace");
        this.serviceName = settings.get("cloud.kubernetes.service");
        this.podLabel = settings.get("cloud.kubernetes.pod_label");
        this.podPort = settings.get("cloud.kubernetes.pod_port") != null ? Integer.parseInt(settings.get("cloud.kubernetes.pod_port")) : 0;
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
        AccessController.doPrivileged(() -> {
            result.addAll(this.readNodes());
            return null;
        });
        return result;
    }

    private List<DiscoveryNode> getDiscoveryNodes(String formattedAddress, InetAddress address, int port) {
        try {
            TransportAddress[] addresses = this.transportService.addressesFromString(formattedAddress + ":" + port, 1);
            return Arrays.stream(addresses).map(transportAddress -> {
                this.logger.info("adding pod {}, transport_address {}", new Object[]{address, transportAddress});
                return new DiscoveryNode("#cloud-" + address + "-" + 0, transportAddress, this.version.minimumCompatibilityVersion());
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.warn("failed to add endpoint {}", (Throwable)e, new Object[]{address});
            return new ArrayList<DiscoveryNode>();
        }
    }

    private List<DiscoveryNode> mapToDiscoveryNodes(List<Pod> pods, String ipAddress) {
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        pods.stream().forEach(pod -> {
            String ip = pod.getStatus().getPodIP();
            try {
                InetAddress podAddress = InetAddress.getByName(ip);
                String formattedPodAddress = NetworkAddress.format((InetAddress)podAddress);
                if (formattedPodAddress.equals(ipAddress)) {
                    this.logger.trace("current node found. Ignoring {}", new Object[]{podAddress});
                } else {
                    discoveryNodes.addAll(this.getDiscoveryNodes(formattedPodAddress, podAddress, this.podPort));
                }
            }
            catch (UnknownHostException e) {
                this.logger.warn("Ignoring invalid pod IP address: {}", (Throwable)e, new Object[]{ip});
            }
        });
        return discoveryNodes;
    }

    private List<DiscoveryNode> mapToDiscoveryNodes(Endpoints endpoints, String ipAddress) {
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        endpoints.getSubsets().stream().forEach(endpointSubset -> endpointSubset.getAddresses().stream().forEach(address -> {
            block5: {
                String ip = address.getIp();
                try {
                    InetAddress endpointAddress = InetAddress.getByName(ip);
                    String formattedEndpointAddress = NetworkAddress.format((InetAddress)endpointAddress);
                    try {
                        if (formattedEndpointAddress.equals(ipAddress)) {
                            this.logger.trace("current node found. Ignoring {}", new Object[]{ipAddress});
                            break block5;
                        }
                        discoveryNodes.addAll(endpointSubset.getPorts().stream().flatMap(port -> this.getDiscoveryNodes(formattedEndpointAddress, endpointAddress, port.getPort()).stream()).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to add endpoint {}", (Throwable)e, new Object[]{endpointAddress});
                    }
                }
                catch (UnknownHostException e) {
                    this.logger.warn("Ignoring invalid endpoint IP address: {}", (Throwable)e, new Object[]{ip});
                }
            }
        }));
        return discoveryNodes;
    }

    private List<DiscoveryNode> readNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list", new Object[0]);
                }
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API", new Object[0]);
        this.cachedDiscoNodes = new ArrayList<DiscoveryNode>();
        String tmpIPAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddresses(null);
            if (inetAddress != null) {
                tmpIPAddress = NetworkAddress.format((InetAddress)inetAddress);
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to find the publish host address", (Throwable)e, new Object[0]);
        }
        String ipAddress = tmpIPAddress;
        try {
            List<DiscoveryNode> discoveryNodes;
            if (this.podLabel != null) {
                List<Pod> pods = this.kubernetesAPIService.pods();
                if (pods == null || pods.isEmpty()) {
                    this.logger.warn("no endpoints found for service [{}], namespace [{}].", new Object[]{this.serviceName, this.namespace});
                    return this.cachedDiscoNodes;
                }
                discoveryNodes = this.mapToDiscoveryNodes(pods, ipAddress);
            } else {
                Endpoints endpoints = this.kubernetesAPIService.endpoints();
                if (endpoints == null || endpoints.getSubsets() == null || endpoints.getSubsets().isEmpty()) {
                    this.logger.warn("no endpoints found for service [{}], namespace [{}].", new Object[]{this.serviceName, this.namespace});
                    return this.cachedDiscoNodes;
                }
                discoveryNodes = this.mapToDiscoveryNodes(endpoints, ipAddress);
            }
            this.cachedDiscoNodes.addAll(discoveryNodes);
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery: {}", e, new Object[]{e.getMessage()});
        }
        this.logger.debug("{} node(s) added", new Object[]{this.cachedDiscoNodes.size()});
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{this.cachedDiscoNodes});
        return this.cachedDiscoNodes;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

