/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableGitSourceRevision;
import io.fabric8.openshift.api.model.GitSourceRevision;
import io.fabric8.openshift.api.model.GitSourceRevisionFluent;
import io.fabric8.openshift.api.model.GitSourceRevisionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GitSourceRevisionBuilder
extends GitSourceRevisionFluentImpl<GitSourceRevisionBuilder>
implements VisitableBuilder<GitSourceRevision, GitSourceRevisionBuilder> {
    GitSourceRevisionFluent<?> fluent;

    public GitSourceRevisionBuilder() {
        this(new GitSourceRevision());
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent) {
        this(fluent, new GitSourceRevision());
    }

    public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent, GitSourceRevision instance) {
        this.fluent = fluent;
        fluent.withAuthor(instance.getAuthor());
        fluent.withCommit(instance.getCommit());
        fluent.withCommitter(instance.getCommitter());
        fluent.withMessage(instance.getMessage());
    }

    public GitSourceRevisionBuilder(GitSourceRevision instance) {
        this.fluent = this;
        this.withAuthor(instance.getAuthor());
        this.withCommit(instance.getCommit());
        this.withCommitter(instance.getCommitter());
        this.withMessage(instance.getMessage());
    }

    @Override
    public EditableGitSourceRevision build() {
        EditableGitSourceRevision buildable = new EditableGitSourceRevision(this.fluent.getAuthor(), this.fluent.getCommit(), this.fluent.getCommitter(), this.fluent.getMessage());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitSourceRevisionBuilder that = (GitSourceRevisionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

