/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildRequestFluentImpl<T extends BuildRequestFluent<T>>
extends BaseFluent<T>
implements BuildRequestFluent<T> {
    BuildRequest.ApiVersion apiVersion;
    VisitableBuilder<BinaryBuildSource, ?> binary;
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    VisitableBuilder<ObjectReference, ?> from;
    String kind;
    Integer lastVersion;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<SourceRevision, ?> revision;
    VisitableBuilder<ObjectReference, ?> triggeredByImage;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildRequestFluentImpl() {
    }

    public BuildRequestFluentImpl(BuildRequest instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withBinary(instance.getBinary());
        this.withEnv(instance.getEnv());
        this.withFrom(instance.getFrom());
        this.withKind(instance.getKind());
        this.withLastVersion(instance.getLastVersion());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withTriggeredByImage(instance.getTriggeredByImage());
    }

    @Override
    public BuildRequest.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(BuildRequest.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public BinaryBuildSource getBinary() {
        return this.binary != null ? (BinaryBuildSource)this.binary.build() : null;
    }

    @Override
    public T withBinary(BinaryBuildSource binary) {
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.add(this.binary);
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.BinaryNested<T> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildRequestFluent.BinaryNested<T> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.BinaryNested<T> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public T withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public T addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    @Override
    public T withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.EnvNested<T> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public BuildRequestFluent.EnvNested<T> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(item);
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public T withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.FromNested<T> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public BuildRequestFluent.FromNested<T> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.FromNested<T> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public Integer getLastVersion() {
        return this.lastVersion;
    }

    @Override
    public T withLastVersion(Integer lastVersion) {
        this.lastVersion = lastVersion;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildRequestFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    @Override
    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.RevisionNested<T> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildRequestFluent.RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public ObjectReference getTriggeredByImage() {
        return this.triggeredByImage != null ? (ObjectReference)this.triggeredByImage.build() : null;
    }

    @Override
    public T withTriggeredByImage(ObjectReference triggeredByImage) {
        if (triggeredByImage != null) {
            this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
            this._visitables.add(this.triggeredByImage);
        }
        return (T)this;
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<T> withNewTriggeredByImage() {
        return new TriggeredByImageNestedImpl();
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<T> withNewTriggeredByImageLike(ObjectReference item) {
        return new TriggeredByImageNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<T> editTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRequestFluentImpl that = (BuildRequestFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastVersion != null ? !this.lastVersion.equals(that.lastVersion) : that.lastVersion != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.triggeredByImage != null ? !this.triggeredByImage.equals(that.triggeredByImage) : that.triggeredByImage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TriggeredByImageNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.TriggeredByImageNested<N>>
    implements BuildRequestFluent.TriggeredByImageNested<N> {
        private final ObjectReferenceBuilder builder;

        TriggeredByImageNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        TriggeredByImageNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withTriggeredByImage(this.builder.build());
        }

        @Override
        public N endTriggeredByImage() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildRequestFluent.RevisionNested<N>>
    implements BuildRequestFluent.RevisionNested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withRevision(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BuildRequestFluent.MetadataNested<N>>
    implements BuildRequestFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.FromNested<N>>
    implements BuildRequestFluent.FromNested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withFrom(this.builder.build());
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<BuildRequestFluent.EnvNested<N>>
    implements BuildRequestFluent.EnvNested<N> {
        private final EnvVarBuilder builder;

        EnvNestedImpl() {
            this.builder = new EnvVarBuilder(this);
        }

        EnvNestedImpl(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        @Override
        public N endEnv() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.addToEnv(this.builder.build());
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildRequestFluent.BinaryNested<N>>
    implements BuildRequestFluent.BinaryNested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

