/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HorizontalPodAutoscalerListFluentImpl<T extends HorizontalPodAutoscalerListFluent<T>>
extends BaseFluent<T>
implements HorizontalPodAutoscalerListFluent<T> {
    HorizontalPodAutoscalerList.ApiVersion apiVersion;
    List<VisitableBuilder<HorizontalPodAutoscaler, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public HorizontalPodAutoscalerListFluentImpl() {
    }

    public HorizontalPodAutoscalerListFluentImpl(HorizontalPodAutoscalerList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public HorizontalPodAutoscalerList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(HorizontalPodAutoscalerList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToItems(HorizontalPodAutoscaler ... items) {
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromItems(HorizontalPodAutoscaler ... items) {
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<HorizontalPodAutoscaler> getItems() {
        return this.build(this.items);
    }

    @Override
    public T withItems(List<HorizontalPodAutoscaler> items) {
        this.items.clear();
        if (items != null) {
            for (HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withItems(HorizontalPodAutoscaler ... items) {
        this.items.clear();
        if (items != null) {
            for (HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<T> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<T> addNewItemLike(HorizontalPodAutoscaler item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerListFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerListFluent.MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerListFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerListFluentImpl that = (HorizontalPodAutoscalerListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<HorizontalPodAutoscalerListFluent.MetadataNested<N>>
    implements HorizontalPodAutoscalerListFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerListFluent.ItemsNested<N>>
    implements HorizontalPodAutoscalerListFluent.ItemsNested<N> {
        private final HorizontalPodAutoscalerBuilder builder;

        ItemsNestedImpl(HorizontalPodAutoscaler item) {
            this.builder = new HorizontalPodAutoscalerBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new HorizontalPodAutoscalerBuilder(this);
        }

        @Override
        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerListFluentImpl.this.addToItems(this.builder.build());
        }
    }
}

