/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.ws;

import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.ws.WebSocketReader;
import com.squareup.okhttp.internal.ws.WebSocketWriter;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Random;
import java.util.concurrent.Executor;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public abstract class RealWebSocket
implements WebSocket {
    private static final int CLOSE_PROTOCOL_EXCEPTION = 1002;
    private final WebSocketWriter writer;
    private final WebSocketReader reader;
    private final WebSocketListener listener;
    private volatile boolean writerSentClose;
    private volatile boolean readerSentClose;
    private final Object closeLock = new Object();

    public RealWebSocket(boolean isClient, BufferedSource source, BufferedSink sink, Random random, final Executor replyExecutor, final WebSocketListener listener, final String url) {
        this.listener = listener;
        this.writer = new WebSocketWriter(isClient, sink, random);
        this.reader = new WebSocketReader(isClient, source, new WebSocketReader.FrameCallback(){

            @Override
            public void onMessage(BufferedSource source, WebSocket.PayloadType type) throws IOException {
                listener.onMessage(source, type);
            }

            @Override
            public void onPing(final Buffer buffer) {
                replyExecutor.execute((Runnable)new NamedRunnable("OkHttp %s WebSocket Pong Reply", new Object[]{url}){

                    protected void execute() {
                        try {
                            RealWebSocket.this.writer.writePong(buffer);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }

            @Override
            public void onPong(Buffer buffer) {
                listener.onPong(buffer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClose(final int code, final String reason) {
                boolean writeCloseResponse;
                Object object = RealWebSocket.this.closeLock;
                synchronized (object) {
                    RealWebSocket.this.readerSentClose = true;
                    writeCloseResponse = !RealWebSocket.this.writerSentClose;
                }
                replyExecutor.execute((Runnable)new NamedRunnable("OkHttp %s WebSocket Close Reply", new Object[]{url}){

                    protected void execute() {
                        RealWebSocket.this.peerClose(code, reason, writeCloseResponse);
                    }
                });
            }
        });
    }

    public boolean readMessage() {
        try {
            this.reader.processNextFrame();
            return !this.readerSentClose;
        }
        catch (IOException e) {
            this.readerErrorClose(e);
            return false;
        }
    }

    @Override
    public BufferedSink newMessageSink(WebSocket.PayloadType type) {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        return this.writer.newMessageSink(type);
    }

    @Override
    public void sendMessage(WebSocket.PayloadType type, Buffer payload) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        this.writer.sendMessage(type, payload);
    }

    @Override
    public void sendPing(Buffer payload) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        this.writer.writePing(payload);
    }

    public void sendPong(Buffer payload) throws IOException {
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        this.writer.writePong(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int code, String reason) throws IOException {
        boolean closeConnection;
        if (this.writerSentClose) {
            throw new IllegalStateException("closed");
        }
        Object object = this.closeLock;
        synchronized (object) {
            this.writerSentClose = true;
            closeConnection = this.readerSentClose;
        }
        this.writer.writeClose(code, reason);
        if (closeConnection) {
            this.closeConnection();
        }
    }

    private void peerClose(int code, String reason, boolean writeCloseResponse) {
        if (writeCloseResponse) {
            try {
                this.writer.writeClose(code, reason);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listener.onClose(code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerErrorClose(IOException e) {
        boolean writeCloseResponse;
        Object object = this.closeLock;
        synchronized (object) {
            this.readerSentClose = true;
            writeCloseResponse = !this.writerSentClose;
        }
        if (writeCloseResponse && e instanceof ProtocolException) {
            try {
                this.writer.writeClose(1002, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listener.onFailure(e, null);
    }

    protected abstract void closeConnection() throws IOException;
}

