/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class KubernetesUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final Version version;
    private final String namespace;
    private final String serviceName;
    private final TimeValue refreshInterval;
    private final KubernetesAPIService kubernetesAPIService;
    private TransportService transportService;
    private NetworkService networkService;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public KubernetesUnicastHostsProvider(Settings settings, KubernetesAPIService kubernetesAPIService, TransportService transportService, NetworkService networkService, Version version) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.kubernetesAPIService = kubernetesAPIService;
        this.version = version;
        this.refreshInterval = settings.getAsTime("cloud.kubernetes.refresh_interval", TimeValue.timeValueSeconds((long)0L));
        this.namespace = settings.get("cloud.kubernetes.namespace");
        this.serviceName = settings.get("cloud.kubernetes.service");
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list", new Object[0]);
                }
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API", new Object[0]);
        this.cachedDiscoNodes = new ArrayList<DiscoveryNode>();
        String tmpIPAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddress(null);
            if (inetAddress != null) {
                tmpIPAddress = NetworkAddress.formatAddress((InetAddress)inetAddress);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String ipAddress = tmpIPAddress;
        try {
            Endpoints endpoints = this.kubernetesAPIService.endpoints();
            if (endpoints == null || endpoints.getSubsets() == null || endpoints.getSubsets().isEmpty()) {
                this.logger.warn("no endpoints found for service [{}], namespace [{}].", new Object[]{this.serviceName, this.namespace});
                return this.cachedDiscoNodes;
            }
            endpoints.getSubsets().stream().forEach(endpointSubset -> endpointSubset.getAddresses().stream().forEach(address -> {
                block5: {
                    String ip = address.getIp();
                    try {
                        InetAddress endpointAddress = InetAddress.getByName(ip);
                        String formattedEndpointAddress = NetworkAddress.formatAddress((InetAddress)endpointAddress);
                        try {
                            if (formattedEndpointAddress.equals(ipAddress)) {
                                this.logger.trace("current node found. Ignoring {}", new Object[]{ipAddress});
                                break block5;
                            }
                            endpointSubset.getPorts().stream().forEach(port -> {
                                try {
                                    TransportAddress[] addresses;
                                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(formattedEndpointAddress + ":" + port.getPort(), 1)) {
                                        this.logger.info("adding endpoint {}, transport_address {}", new Object[]{endpointAddress, transportAddress});
                                        this.cachedDiscoNodes.add(new DiscoveryNode("#cloud-" + endpointAddress + "-" + 0, transportAddress, this.version.minimumCompatibilityVersion()));
                                    }
                                }
                                catch (Exception e) {
                                    this.logger.warn("failed to add endpoint {}", (Throwable)e, new Object[]{endpointAddress});
                                }
                            });
                        }
                        catch (Exception e) {
                            this.logger.warn("failed to add endpoint {}", (Throwable)e, new Object[]{endpointAddress});
                        }
                    }
                    catch (UnknownHostException e) {
                        this.logger.warn("Ignoring invalid endpoint IP address: {}", (Throwable)e, new Object[]{ip});
                    }
                }
            }));
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery: {}", e, new Object[]{e.getMessage()});
        }
        this.logger.debug("{} node(s) added", new Object[]{this.cachedDiscoNodes.size()});
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{this.cachedDiscoNodes});
        return this.cachedDiscoNodes;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

