/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesModule;
import io.fabric8.elasticsearch.discovery.kubernetes.KubernetesDiscovery;
import io.fabric8.elasticsearch.discovery.kubernetes.KubernetesUnicastHostsProvider;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.plugins.Plugin;

public class KubernetesDiscoveryPlugin
extends Plugin {
    protected final ESLogger logger = Loggers.getLogger(KubernetesDiscoveryPlugin.class);
    private final Settings settings;

    public KubernetesDiscoveryPlugin(Settings settings) {
        this.settings = settings;
    }

    public static boolean isDiscoveryAlive(Settings settings, ESLogger logger) {
        if (!"kubernetes".equalsIgnoreCase(settings.get("discovery.type"))) {
            logger.debug("discovery.type not set to {}", new Object[]{"kubernetes"});
            return false;
        }
        if (!KubernetesDiscoveryPlugin.checkProperty("cloud.kubernetes.namespace", settings.get("cloud.kubernetes.namespace"), logger) || !KubernetesDiscoveryPlugin.checkProperty("cloud.kubernetes.service", settings.get("cloud.kubernetes.service"), logger)) {
            logger.debug("one or more Kubernetes discovery settings are missing. Check elasticsearch.yml file. Should have [{}] and [{}].", new Object[]{"cloud.kubernetes.namespace", "cloud.kubernetes.service"});
            return false;
        }
        logger.trace("all required properties for Kubernetes discovery are set!", new Object[0]);
        return true;
    }

    private static boolean checkProperty(String name, String value, ESLogger logger) {
        if (!Strings.hasText((String)value)) {
            logger.warn("{} is not set.", new Object[]{name});
            return false;
        }
        return true;
    }

    public String name() {
        return "discovery-kubernetes";
    }

    public String description() {
        return "Cloud Kubernetes Discovery Plugin";
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, this.logger)) {
            modules.add((Module)new KubernetesModule());
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> nodeServices() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, this.logger)) {
            services.add(KubernetesModule.getComputeServiceImpl());
        }
        return services;
    }

    public void onModule(DiscoveryModule discoveryModule) {
        if (KubernetesDiscoveryPlugin.isDiscoveryAlive(this.settings, this.logger)) {
            discoveryModule.addDiscoveryType("kubernetes", KubernetesDiscovery.class);
            discoveryModule.addUnicastHostProvider(KubernetesUnicastHostsProvider.class);
        }
    }
}

