/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class KubernetesUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final Version version;
    private final String namespace;
    private final String serviceName;
    private final TimeValue refreshInterval;
    private final KubernetesAPIService kubernetesAPIService;
    private TransportService transportService;
    private NetworkService networkService;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public KubernetesUnicastHostsProvider(Settings settings, KubernetesAPIService kubernetesAPIService, TransportService transportService, NetworkService networkService, Version version) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.kubernetesAPIService = kubernetesAPIService;
        this.version = version;
        this.refreshInterval = settings.getAsTime("cloud.kubernetes.refresh_interval", TimeValue.timeValueSeconds((long)0L));
        this.namespace = settings.get("cloud.kubernetes.namespace");
        this.serviceName = settings.get("cloud.kubernetes.service");
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list", new Object[0]);
                }
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API", new Object[0]);
        this.cachedDiscoNodes = new ArrayList<DiscoveryNode>();
        String ipAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddress(null);
            if (inetAddress != null) {
                ipAddress = NetworkAddress.formatAddress((InetAddress)inetAddress);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Collection<InetAddress> endpoints = this.kubernetesAPIService.endpoints();
            if (endpoints == null) {
                this.logger.trace("no endpoints found for service [{}], namespace [{}].", new Object[]{this.serviceName, this.namespace});
                return this.cachedDiscoNodes;
            }
            for (InetAddress endpoint : endpoints) {
                String endpointAddress = NetworkAddress.formatAddress((InetAddress)endpoint);
                try {
                    TransportAddress[] addresses;
                    if (endpointAddress.equals(ipAddress)) {
                        this.logger.trace("current node found. Ignoring {}", new Object[]{ipAddress});
                        continue;
                    }
                    endpointAddress = endpointAddress.concat(":9200");
                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(endpointAddress, 1)) {
                        this.logger.trace("adding endpoint {}, transport_address {}", new Object[]{endpointAddress, transportAddress});
                        this.cachedDiscoNodes.add(new DiscoveryNode("#cloud-" + endpointAddress + "-" + 0, transportAddress, this.version.minimumCompatibilityVersion()));
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed to add endpoint {}", new Object[]{endpointAddress});
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery: {}", e, new Object[]{e.getMessage()});
        }
        this.logger.debug("{} node(s) added", new Object[]{this.cachedDiscoNodes.size()});
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{this.cachedDiscoNodes});
        return this.cachedDiscoNodes;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

