/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.cloud.kubernetes;

import io.fabric8.elasticsearch.cloud.kubernetes.KubernetesAPIService;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;

public class KubernetesAPIServiceImpl
extends AbstractLifecycleComponent<KubernetesAPIService>
implements KubernetesAPIService {
    private final String namespace;
    private final String serviceName;
    private KubernetesClient client;

    @Override
    public Collection<InetAddress> endpoints() {
        this.logger.debug("get endpoints for service {}, namespace {}", new Object[]{this.serviceName, this.namespace});
        HashSet<InetAddress> instances = new HashSet<InetAddress>();
        ((Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.client().endpoints().inNamespace(this.namespace)).withName(this.serviceName)).get()).getSubsets().stream().forEach(endpointSubset -> endpointSubset.getAddresses().stream().forEach(endpointAddress -> {
            String ip = endpointAddress.getIp();
            try {
                instances.add(InetAddress.getByName(ip));
            }
            catch (UnknownHostException e) {
                this.logger.warn("Ignoring invalid endpoint IP address: {}", new Object[]{ip});
            }
        }));
        if (instances.isEmpty()) {
            this.logger.warn("disabling Kubernetes discovery. Can not get list of endpoints", new Object[0]);
        }
        return instances;
    }

    @Inject
    public KubernetesAPIServiceImpl(Settings settings, NetworkService networkService) {
        super(settings);
        this.namespace = settings.get("cloud.kubernetes.namespace");
        this.serviceName = settings.get("cloud.kubernetes.service");
    }

    public synchronized KubernetesClient client() {
        if (this.client == null) {
            this.client = new DefaultKubernetesClient();
        }
        return this.client;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void doClose() throws ElasticsearchException {
    }
}

