/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageBuilder
extends ImageFluent<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;

    public ImageBuilder() {
        this(new Image());
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, new Image());
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withDockerImageManifest(instance.getDockerImageManifest());
        fluent.withDockerImageMetadata(instance.getDockerImageMetadata());
        fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public ImageBuilder(Image instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageMetadata(instance.getDockerImageMetadata());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public Image build() {
        Image buildable = new Image(this.fluent.getApiVersion(), this.fluent.getDockerImageManifest(), this.fluent.getDockerImageMetadata(), this.fluent.getDockerImageMetadataVersion(), this.fluent.getDockerImageReference(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

