/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "dockerImageManifest", "dockerImageMetadata", "dockerImageMetadataVersion", "dockerImageReference", "kind", "metadata"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Image
implements HasMetadata {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta3");
    @JsonProperty(value="dockerImageManifest")
    private String dockerImageManifest;
    @JsonProperty(value="dockerImageMetadata")
    @Valid
    private HasMetadata dockerImageMetadata;
    @JsonProperty(value="dockerImageMetadataVersion")
    private String dockerImageMetadataVersion;
    @JsonProperty(value="dockerImageReference")
    private String dockerImageReference;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Image";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Image() {
    }

    public Image(ApiVersion apiVersion, String dockerImageManifest, HasMetadata dockerImageMetadata, String dockerImageMetadataVersion, String dockerImageReference, String kind, ObjectMeta metadata) {
        this.apiVersion = apiVersion;
        this.dockerImageManifest = dockerImageManifest;
        this.dockerImageMetadata = dockerImageMetadata;
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        this.dockerImageReference = dockerImageReference;
        this.kind = kind;
        this.metadata = metadata;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="dockerImageManifest")
    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    @JsonProperty(value="dockerImageManifest")
    public void setDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
    }

    @JsonProperty(value="dockerImageMetadata")
    public HasMetadata getDockerImageMetadata() {
        return this.dockerImageMetadata;
    }

    @JsonProperty(value="dockerImageMetadata")
    public void setDockerImageMetadata(HasMetadata dockerImageMetadata) {
        this.dockerImageMetadata = dockerImageMetadata;
    }

    @JsonProperty(value="dockerImageMetadataVersion")
    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    @JsonProperty(value="dockerImageMetadataVersion")
    public void setDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
    }

    @JsonProperty(value="dockerImageReference")
    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    @JsonProperty(value="dockerImageReference")
    public void setDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append((Object)this.dockerImageManifest).append((Object)this.dockerImageMetadata).append((Object)this.dockerImageMetadataVersion).append((Object)this.dockerImageReference).append((Object)this.kind).append((Object)this.metadata).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Image)) {
            return false;
        }
        Image rhs = (Image)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.dockerImageManifest, (Object)rhs.dockerImageManifest).append((Object)this.dockerImageMetadata, (Object)rhs.dockerImageMetadata).append((Object)this.dockerImageMetadataVersion, (Object)rhs.dockerImageMetadataVersion).append((Object)this.dockerImageReference, (Object)rhs.dockerImageReference).append((Object)this.kind, (Object)rhs.kind).append((Object)this.metadata, (Object)rhs.metadata).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_3("v1beta3"),
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

