/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecBuilder;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.BuildStatusBuilder;
import io.fabric8.openshift.api.model.BuildStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildFluent<T extends BuildFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Build.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<BuildSpec, ?> spec;
    VisitableBuilder<BuildStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Build.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Build.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public BuildSpec getSpec() {
        return this.spec != null ? (BuildSpec)this.spec.build() : null;
    }

    public T withSpec(BuildSpec spec) {
        if (spec != null) {
            this.spec = new BuildSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public BuildStatus getStatus() {
        return this.status != null ? (BuildStatus)this.status.build() : null;
    }

    public T withStatus(BuildStatus status) {
        if (status != null) {
            this.status = new BuildStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends BuildStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final BuildStatusBuilder builder = new BuildStatusBuilder(this);

        @Override
        public N and() {
            return (N)BuildFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends BuildSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final BuildSpecBuilder builder = new BuildSpecBuilder(this);

        @Override
        public N and() {
            return (N)BuildFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildFluent.this.withMetadata(this.builder.build());
        }
    }
}

