/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildConfigStatus;
import io.fabric8.openshift.api.model.BuildConfigStatusBuilder;
import io.fabric8.openshift.api.model.BuildConfigStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildConfigFluent<T extends BuildConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BuildConfig.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<BuildConfigSpec, ?> spec;
    VisitableBuilder<BuildConfigStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfig.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BuildConfig.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public BuildConfigSpec getSpec() {
        return this.spec != null ? (BuildConfigSpec)this.spec.build() : null;
    }

    public T withSpec(BuildConfigSpec spec) {
        if (spec != null) {
            this.spec = new BuildConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public BuildConfigStatus getStatus() {
        return this.status != null ? (BuildConfigStatus)this.status.build() : null;
    }

    public T withStatus(BuildConfigStatus status) {
        if (status != null) {
            this.status = new BuildConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T withNewStatus(Integer lastVersion) {
        return this.withStatus(new BuildConfigStatus(lastVersion));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends BuildConfigStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final BuildConfigStatusBuilder builder = new BuildConfigStatusBuilder(this);

        public N endStatus() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends BuildConfigSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final BuildConfigSpecBuilder builder = new BuildConfigSpecBuilder(this);

        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withMetadata(this.builder.build());
        }
    }
}

