/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.HashMap;
import java.util.Map;

public class ReplicationControllerSpecFluent<T extends ReplicationControllerSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Integer replicas;
    Map<String, String> selector = new HashMap<String, String>();
    VisitableBuilder<PodTemplateSpec, ?> template;
    VisitableBuilder<ObjectReference, ?> templateRef;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Integer getReplicas() {
        return this.replicas;
    }

    public T withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (T)this;
    }

    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)this;
    }

    public TemplateNested<T> withNewTemplate() {
        return new TemplateNested();
    }

    public ObjectReference getTemplateRef() {
        return this.templateRef != null ? (ObjectReference)this.templateRef.build() : null;
    }

    public T withTemplateRef(ObjectReference templateRef) {
        if (templateRef != null) {
            this.templateRef = new ObjectReferenceBuilder(templateRef);
            this._visitables.add(this.templateRef);
        }
        return (T)this;
    }

    public TemplateRefNested<T> withNewTemplateRef() {
        return new TemplateRefNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class TemplateRefNested<N>
    extends ObjectReferenceFluent<TemplateRefNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder = new ObjectReferenceBuilder(this);

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluent.this.withTemplateRef(this.builder.build());
        }

        public N endTemplateRef() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        private final PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(this);

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

