/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodStatusBuilder
extends PodStatusFluent<PodStatusBuilder>
implements VisitableBuilder<PodStatus, PodStatusBuilder> {
    PodStatusFluent<?> fluent;

    public PodStatusBuilder() {
        this(new PodStatus());
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent) {
        this(fluent, new PodStatus());
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance) {
        this.fluent = fluent;
        fluent.withCondition(instance.getCondition());
        fluent.withContainerStatuses(instance.getContainerStatuses());
        fluent.withHostIP(instance.getHostIP());
        fluent.withMessage(instance.getMessage());
        fluent.withPhase(instance.getPhase());
        fluent.withPodIP(instance.getPodIP());
        fluent.withStartTime(instance.getStartTime());
    }

    public PodStatusBuilder(PodStatus instance) {
        this.fluent = this;
        this.withCondition(instance.getCondition());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public PodStatus build() {
        PodStatus buildable = new PodStatus(this.fluent.getCondition(), this.fluent.getContainerStatuses(), this.fluent.getHostIP(), this.fluent.getMessage(), this.fluent.getPhase(), this.fluent.getPodIP(), this.fluent.getStartTime());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

