/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Handler;
import io.fabric8.kubernetes.api.model.HandlerFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HandlerBuilder
extends HandlerFluent<HandlerBuilder>
implements VisitableBuilder<Handler, HandlerBuilder> {
    HandlerFluent<?> fluent;

    public HandlerBuilder() {
        this(new Handler());
    }

    public HandlerBuilder(HandlerFluent<?> fluent) {
        this(fluent, new Handler());
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withTcpSocket(instance.getTcpSocket());
    }

    public HandlerBuilder(Handler instance) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withTcpSocket(instance.getTcpSocket());
    }

    @Override
    public Handler build() {
        Handler buildable = new Handler(this.fluent.getExec(), this.fluent.getHttpGet(), this.fluent.getTcpSocket());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

