/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.coverters;

import io.sundr.Function;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class JavaTypeFunction
implements Function<String, JavaType> {
    private final Elements elements;

    public JavaTypeFunction(Elements elements) {
        this.elements = elements;
    }

    public JavaType apply(String fullName) {
        return this.apply(fullName, new LinkedHashSet<String>());
    }

    public JavaType apply(String fullName, Set<String> visited) {
        boolean isArray = false;
        String packageName = null;
        String className = null;
        JavaType superClass = null;
        JavaKind kind = JavaKind.CLASS;
        boolean concrete = false;
        LinkedHashSet<JavaType> interfaces = new LinkedHashSet<JavaType>();
        ArrayList<JavaType> genericTypes = new ArrayList<JavaType>();
        if (fullName.equals("<none>")) {
            return null;
        }
        visited.add(fullName);
        TypeElement typeElement = this.elements.getTypeElement(ModelUtils.getFullyQualifiedName(fullName));
        if (typeElement == null) {
            className = fullName;
        } else {
            String superClassName;
            if (typeElement.getKind() == ElementKind.INTERFACE) {
                kind = JavaKind.INTERFACE;
                concrete = false;
            } else if (typeElement.getKind() == ElementKind.CLASS) {
                kind = JavaKind.CLASS;
                concrete = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                String interfaceName = typeMirror.toString();
                if (visited.contains(interfaceName)) continue;
                interfaces.add(this.apply(interfaceName, visited));
            }
            packageName = this.elements.getPackageOf(typeElement).toString();
            String string = className = fullName.contains(packageName) ? fullName.substring(packageName.length() + 1) : fullName;
            if (!"java.lang.Object".equals(fullName) && typeElement.getSuperclass() != null && !visited.contains(superClassName = typeElement.getSuperclass().toString())) {
                superClass = this.apply(superClassName, visited);
            }
        }
        if (fullName.endsWith("[]")) {
            className = className.substring(0, className.indexOf(91));
            isArray = true;
        }
        if (className.contains("<")) {
            String genericTypeList = fullName.substring(fullName.indexOf(60) + 1, fullName.lastIndexOf(62));
            for (String genericType : ModelUtils.splitTypes(genericTypeList)) {
                JavaType t = this.apply(genericType, visited);
                genericTypes.add(t);
            }
            className = className.substring(0, className.indexOf(60));
        }
        JavaType defaultImplementation = null;
        String string = packageName + "." + className;
        boolean collection = false;
        if (string.equals(Set.class.getCanonicalName())) {
            defaultImplementation = this.apply(LinkedHashSet.class.getCanonicalName(), visited);
            collection = true;
        } else if (string.equals(List.class.getCanonicalName())) {
            defaultImplementation = this.apply(ArrayList.class.getCanonicalName(), visited);
            collection = true;
        } else if (string.equals(Map.class.getCanonicalName())) {
            defaultImplementation = this.apply(HashMap.class.getCanonicalName(), visited);
            collection = true;
        }
        EditableJavaType type = ((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)((JavaTypeBuilder)((Object)new JavaTypeBuilder().withKind(kind))).withPackageName(packageName))).withClassName(className))).withArray(isArray))).withConcrete(concrete))).withCollection(collection))).withDefaultImplementation(defaultImplementation))).withInterfaces(interfaces))).withSuperClass(superClass))).withGenericTypes(genericTypes.toArray(new JavaType[genericTypes.size()])))).build();
        return type;
    }
}

