/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.utils;

import io.sundr.codegen.model.EditableJavaMethod;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaClazzFluent;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.ModelUtils;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.dsl.annotations.EntryPoint;
import io.sundr.dsl.annotations.Multiple;
import io.sundr.dsl.annotations.Previous;
import io.sundr.dsl.annotations.TargetName;
import io.sundr.dsl.annotations.Terminal;
import io.sundr.dsl.internal.Constants;
import io.sundr.dsl.internal.processor.DslProcessorContext;
import io.sundr.dsl.internal.type.functions.Generics;
import io.sundr.dsl.internal.type.functions.Merge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public final class JavaTypeUtils {
    private JavaTypeUtils() {
    }

    public static JavaClazz executableToInterface(DslProcessorContext context, ExecutableElement executableElement) {
        String methodName = executableElement.getSimpleName().toString();
        Boolean multiple = executableElement.getAnnotation(Multiple.class) != null;
        Boolean usePreviousTransitions = executableElement.getAnnotation(Previous.class) != null;
        Boolean isEntryPoint = executableElement.getAnnotation(EntryPoint.class) != null;
        Boolean isTerminal = executableElement.getAnnotation(Terminal.class) != null || !JavaTypeUtils.isVoid(executableElement);
        LinkedHashSet transitions = new LinkedHashSet();
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (AnnotationMirror annotationMirror : context.getToTransitionAnnotations().apply(executableElement)) {
            transitions.addAll(context.getToTransitionClassName().apply(annotationMirror));
        }
        for (AnnotationMirror annotationMirror : context.getToKeywordAnnotations().apply(executableElement)) {
            keywords.add(context.getToKeywordClassName().apply(annotationMirror));
        }
        JavaType returnType = null;
        returnType = JavaTypeUtils.isTerminal(executableElement) ? (JavaTypeUtils.isVoid(executableElement) ? Constants.VOID : (JavaType)context.getToType().apply((Object)executableElement.getReturnType().toString())) : Constants.TRANSPARENT;
        JavaType genericType = (JavaType)Generics.MAP.apply(returnType);
        JavaMethod sourceMethod = context.getToMethod().apply(executableElement);
        EditableJavaMethod targetMethod = ((JavaMethodBuilder)new JavaMethodBuilder(sourceMethod).withReturnType(genericType)).build();
        TargetName targetInterfaceName = executableElement.getAnnotation(TargetName.class);
        String interfaceName = targetInterfaceName != null ? targetInterfaceName.value() : JavaTypeUtils.toInterfaceName(targetMethod.getName());
        return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)new JavaClazzBuilder().withNewType().withPackageName(ModelUtils.getPackageElement((Element)executableElement).toString())).withClassName(interfaceName)).addToGenericTypes(genericType)).withKind(JavaKind.INTERFACE)).addToAttributes("ORIGINAL_RETURN_TYPE", (Object)returnType)).addToAttributes("IS_ENTRYPOINT", (Object)isEntryPoint)).addToAttributes("IS_TERMINAL", (Object)isTerminal)).addToAttributes("KEYWORDS", keywords)).addToAttributes("TRANSITIONS", isTerminal != false ? Collections.emptySet() : transitions)).addToAttributes("CARDINALITY_MULTIPLE", (Object)multiple)).addToAttributes("USE_PREVIOUS_TRANSITIONS", (Object)usePreviousTransitions)).addToAttributes("TERMINATING_TYPES", (Object)(isTerminal != false ? new LinkedHashSet<JavaType>(Arrays.asList(returnType)) : Collections.emptySet()))).addToAttributes("METHOD_NAME", (Object)methodName)).endType()).addToMethods((JavaMethod)targetMethod)).build();
    }

    public static Set<JavaClazz> executablesToInterfaces(DslProcessorContext context, Collection<ExecutableElement> elements) {
        LinkedHashMap<String, Object> byName = new LinkedHashMap<String, Object>();
        for (ExecutableElement current : elements) {
            JavaClazz clazz = JavaTypeUtils.executableToInterface(context, current);
            String name = clazz.getType().getFullyQualifiedName();
            if (byName.containsKey(name)) {
                JavaClazz other = (JavaClazz)byName.remove(name);
                byName.put(name, Merge.CLASSES.apply((Object)new JavaClazz[]{other, clazz}));
                continue;
            }
            byName.put(name, clazz);
        }
        return new LinkedHashSet<JavaClazz>(byName.values());
    }

    public static final Set<JavaType> getTerminatingTypes(JavaType type) {
        LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
        if (type.getAttributes().containsKey("TERMINATING_TYPES")) {
            result.addAll((Collection)type.getAttributes().get("TERMINATING_TYPES"));
        }
        if (type.getAttributes().containsKey("IS_COMPOSITE") && ((Boolean)type.getAttributes().get("IS_TERMINAL")).booleanValue() && !type.getAttributes().get("ORIGINAL_RETURN_TYPE").equals(Constants.TRANSPARENT)) {
            result.add((JavaType)type.getAttributes().get("ORIGINAL_RETURN_TYPE"));
        }
        return result;
    }

    public static Set<JavaType> extractInterfaces(Set<JavaType> types) {
        LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
        for (JavaType type : types) {
            result.addAll(JavaTypeUtils.extractInterfaces(type));
        }
        return result;
    }

    public static Set<JavaType> extractInterfaces(JavaType type) {
        LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
        if (type.getInterfaces().isEmpty()) {
            result.add(type);
        } else {
            for (JavaType interfaceType : type.getInterfaces()) {
                result.addAll(JavaTypeUtils.extractInterfaces(interfaceType));
            }
        }
        return result;
    }

    public static String toInterfaceName(String name) {
        if (name.endsWith("Interface")) {
            return name;
        }
        return StringUtils.captializeFirst((String)name) + "Interface";
    }

    public static boolean isVoid(ExecutableElement executableElement) {
        return executableElement.getReturnType().toString().equals("void");
    }

    public static boolean isTerminal(ExecutableElement executableElement) {
        return executableElement.getAnnotation(Terminal.class) != null;
    }

    public static boolean isEntryPoint(JavaClazz clazz) {
        return clazz.getType().getAttributes().containsKey("IS_ENTRYPOINT") && clazz.getType().getAttributes().get("IS_ENTRYPOINT") instanceof Boolean && (Boolean)clazz.getType().getAttributes().get("IS_ENTRYPOINT") != false;
    }

    public static boolean isTerminal(JavaClazz clazz) {
        return clazz.getType().getAttributes().containsKey("IS_TERMINAL") && clazz.getType().getAttributes().get("IS_TERMINAL") instanceof Boolean && (Boolean)clazz.getType().getAttributes().get("IS_TERMINAL") != false;
    }

    public static boolean isCardinalityMultiple(JavaClazz clazz) {
        return clazz.getType().getAttributes().containsKey("CARDINALITY_MULTIPLE") && clazz.getType().getAttributes().get("CARDINALITY_MULTIPLE") instanceof Boolean && (Boolean)clazz.getType().getAttributes().get("CARDINALITY_MULTIPLE") != false;
    }

    public static boolean isGeneric(JavaType type) {
        return type.getAttributes().containsKey("IS_GENERIC") && type.getAttributes().get("IS_GENERIC") instanceof Boolean && (Boolean)type.getAttributes().get("IS_GENERIC") != false;
    }

    public static boolean usePreviousTransitions(JavaClazz clazz) {
        return clazz.getType().getAttributes().containsKey("USE_PREVIOUS_TRANSITIONS") && clazz.getType().getAttributes().get("USE_PREVIOUS_TRANSITIONS") instanceof Boolean && (Boolean)clazz.getType().getAttributes().get("USE_PREVIOUS_TRANSITIONS") != false;
    }
}

