/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.type.functions;

import io.sundr.Function;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.dsl.internal.Constants;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public enum Generics implements Function<JavaType, JavaType>
{
    MAP{

        public JavaType apply(JavaType item) {
            if (!GENERIC_MAPPINGS.containsKey(item)) {
                int iteration = counter / GENERIC_NAMES.length;
                String name = GENERIC_NAMES[counter % GENERIC_NAMES.length];
                if (iteration > 0) {
                    name = name + iteration;
                }
                counter++;
                GENERIC_MAPPINGS.put(item, ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder().withClassName(name)).addToAttributes("IS_GENERIC", (Object)true)).build());
            }
            return (JavaType)GENERIC_MAPPINGS.get(item);
        }
    }
    ,
    UNMAP{

        public JavaType apply(JavaType item) {
            for (Map.Entry enty : GENERIC_MAPPINGS.entrySet()) {
                JavaType value = (JavaType)enty.getValue();
                if (!value.equals((Object)item)) continue;
                return (JavaType)enty.getKey();
            }
            return item;
        }
    }
    ,
    UNWRAP{

        public JavaType apply(JavaType type) {
            LinkedHashSet<Object> interfaces = new LinkedHashSet<Object>();
            LinkedHashSet<Object> generics = new LinkedHashSet<Object>();
            if (GENERIC_MAPPINGS.containsValue(type)) {
                return (JavaType)UNMAP.apply(type);
            }
            for (JavaType iface : type.getInterfaces()) {
                interfaces.add(UNWRAP.apply(iface));
            }
            for (JavaType generic : type.getGenericTypes()) {
                generics.add(UNWRAP.apply(generic));
            }
            return ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(type).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withInterfaces(interfaces)).build();
        }
    };

    private static final String[] GENERIC_NAMES;
    private static final Map<JavaType, JavaType> GENERIC_MAPPINGS;
    private static int counter;

    static {
        GENERIC_NAMES = new String[]{"X", "Y", "Z"};
        GENERIC_MAPPINGS = new HashMap<JavaType, JavaType>();
        counter = 0;
        GENERIC_MAPPINGS.put(Constants.VOID, (JavaType)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder().withClassName("V")).addToAttributes("IS_GENERIC", (Object)true)).build());
        GENERIC_MAPPINGS.put(Constants.TRANSPARENT, Constants.TRANSPARENT);
    }
}

