/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.processor;

import io.sundr.codegen.model.EditableJavaMethod;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaClazzFluent;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.processor.JavaGeneratingProcessor;
import io.sundr.codegen.utils.ModelUtils;
import io.sundr.dsl.annotations.TargetName;
import io.sundr.dsl.internal.processor.DslProcessorContext;
import io.sundr.dsl.internal.processor.Node;
import io.sundr.dsl.internal.utils.DslUtils;
import io.sundr.dsl.internal.utils.GraphUtils;
import io.sundr.dsl.internal.utils.JavaTypeUtils;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"io.sundr.dsl.annotations.Dsl"})
public class DslProcessor
extends JavaGeneratingProcessor {
    public static final String DEFAULT_TEMPLATE_LOCATION = "templates/dsl/dsl.vm";

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        DslProcessorContext context = new DslProcessorContext(elements, types);
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElement2 = (TypeElement)element;
                TargetName targetName = element.getAnnotation(TargetName.class);
                String targetInterface = targetName.value();
                LinkedHashSet<JavaClazz> interfacesToGenerate = new LinkedHashSet<JavaClazz>();
                Set sorted = context.getDependencyManager().sort(ElementFilter.methodsIn(typeElement2.getEnclosedElements()));
                Set<JavaClazz> genericInterfaces = JavaTypeUtils.executablesToInterfaces(context, sorted);
                for (JavaClazz clazz : genericInterfaces) {
                    if (JavaTypeUtils.isEntryPoint(clazz)) continue;
                    interfacesToGenerate.add(clazz);
                }
                LinkedHashSet<EditableJavaMethod> methods = new LinkedHashSet<EditableJavaMethod>();
                Set<Node<JavaClazz>> graph = GraphUtils.createGraph(genericInterfaces);
                for (Node<JavaClazz> root : graph) {
                    JavaClazz current = root.getItem();
                    methods.add(((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withName((String)current.getType().getAttributes().get("METHOD_NAME"))).withReturnType(current.getType())).build());
                    interfacesToGenerate.add(DslUtils.createRootInterface(root, interfacesToGenerate));
                }
                interfacesToGenerate.add((JavaClazz)((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)((JavaClazzFluent.TypeNested)new JavaClazzBuilder().withNewType().withPackageName(ModelUtils.getPackageElement((Element)element).toString())).withClassName(targetInterface)).withKind(JavaKind.INTERFACE)).and()).withMethods(methods)).build());
                try {
                    for (JavaClazz clazz : interfacesToGenerate) {
                        this.generateFromClazz(clazz, DEFAULT_TEMPLATE_LOCATION);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }
}

