/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.element.functions;

import io.sundr.Function;
import io.sundr.dsl.annotations.AnnotationTransition;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ToTransitionClassName
implements Function<AnnotationMirror, List<String>> {
    private final TypeElement ANNOTATED_TRANSITION;
    private final Element ANNOTATION_VALUE;

    public ToTransitionClassName(Elements elements) {
        this.ANNOTATED_TRANSITION = elements.getTypeElement(AnnotationTransition.class.getCanonicalName());
        this.ANNOTATION_VALUE = this.ANNOTATED_TRANSITION.getEnclosedElements().get(0);
    }

    public List<String> apply(AnnotationMirror annotationMirror) {
        ArrayList<String> classNames = new ArrayList<String>();
        if (annotationMirror.getAnnotationType().asElement().equals(this.ANNOTATED_TRANSITION)) {
            Object value = annotationMirror.getElementValues().get(this.ANNOTATION_VALUE).getValue();
            if (value instanceof String) {
                classNames.add(ToTransitionClassName.removeSuffix((String)value));
            } else if (value instanceof List) {
                List list = (List)value;
                for (Object item : list) {
                    String str = String.valueOf(item);
                    classNames.add(ToTransitionClassName.removeSuffix(str));
                }
            }
            return classNames;
        }
        return null;
    }

    private static String removeSuffix(String str) {
        if (str.endsWith(".class")) {
            return str.substring(0, str.length() - 6);
        }
        return str;
    }
}

