/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.element.functions;

import io.sundr.Function;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ToAnnotationMirrors
implements Function<ExecutableElement, Set<AnnotationMirror>> {
    private final TypeElement ANNOTATED_TRANSITION;
    private final Class<? extends Annotation> annotationClass;

    public ToAnnotationMirrors(Elements elements, Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
        this.ANNOTATED_TRANSITION = elements.getTypeElement(annotationClass.getCanonicalName());
    }

    public Set<AnnotationMirror> apply(ExecutableElement element) {
        LinkedHashSet<AnnotationMirror> annotationMirrors = new LinkedHashSet<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().asElement().equals(this.ANNOTATED_TRANSITION)) {
                annotationMirrors.add(annotationMirror);
            }
            for (AnnotationMirror annotationMirror2 : annotationMirror.getAnnotationType().asElement().getAnnotationMirrors()) {
                if (!annotationMirror2.getAnnotationType().asElement().equals(this.ANNOTATED_TRANSITION)) continue;
                annotationMirrors.add(annotationMirror2);
            }
        }
        return annotationMirrors;
    }
}

