/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.ClazzAs;
import io.sundr.builder.internal.processor.AbstractBuilderProcessor;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.utils.ModelUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.sundr.builder.annotations.ExternalBuildables"})
public class ExternalBuildableProcessor
extends AbstractBuilderProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        TypeElement typeElement;
        ExternalBuildables generated;
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement2 : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement2)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                BuilderContextManager.create(elements, generated.builderPackage());
                for (String name : generated.value()) {
                    typeElement = elements.getTypeElement(name);
                    BuilderContextManager.getContext().getRepository().register(typeElement);
                }
            }
        }
        for (TypeElement typeElement3 : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement3)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                for (String name : generated.value()) {
                    typeElement = elements.getTypeElement(name);
                    if (typeElement == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Type:" + name + " doesn't exists. Ignoring...");
                        continue;
                    }
                    JavaClazz clazz = BuilderContextManager.getContext().getToClazz().apply(ModelUtils.getClassElement((Element)typeElement));
                    this.generateLocalDependenciesIfNeeded();
                    try {
                        this.generateFromClazz((JavaClazz)ClazzAs.FLUENT.apply(clazz), "templates/builder/fluent.vm");
                        if (generated.editableEnabled()) {
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE_BUILDER.apply(clazz), this.selectBuilderTemplate(generated.validationEnabled()));
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE.apply(clazz), "templates/builder/editable.vm");
                            continue;
                        }
                        this.generateFromClazz((JavaClazz)ClazzAs.BUILDER.apply(clazz), this.selectBuilderTemplate(generated.validationEnabled()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return true;
    }
}

