/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import java.util.Set;
import javax.lang.model.element.Modifier;

public enum ToMethod implements Function<JavaProperty, JavaMethod>
{
    WITH{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "with" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{property})).addToAttributes("BODY", (Object)this.getBody(property))).build();
        }

        private String getBody(JavaProperty property) {
            String name = property.getName();
            JavaType type = property.getType();
            String className = type.getClassName();
            StringBuilder sb = new StringBuilder();
            if (type.isCollection()) {
                sb.append("this." + name + ".clear();");
                if (className.contains("Map")) {
                    sb.append("if (" + name + " != null) {this." + name + ".putAll(" + name + ");} return (T) this;");
                } else if (className.contains("List") || className.contains("Set")) {
                    JavaType unwraped = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType());
                    String addToMethodName = "addTo" + property.getNameCapitalized();
                    sb.append("if (" + name + " != null) {for (" + unwraped.getSimpleName() + " item : " + name + "){this." + addToMethodName + "(item);}} return (T) this;");
                }
                return sb.toString();
            }
            if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                JavaType builder = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.BUILDER).apply((Object)property.getType());
                String propertyName = property.getName();
                String builderClass = builder.getSimpleName();
                return "if (" + propertyName + "!=null){ this." + propertyName + "= new " + builderClass + "(" + propertyName + "); _visitables.add(this." + propertyName + ");} return (T) this;";
            }
            return "this." + property.getName() + "=" + property.getName() + "; return (T) this;";
        }
    }
    ,
    WITH_ARRAY{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "with" + property.getNameCapitalized();
            JavaType unwraped = (JavaType)TypeAs.UNWRAP_ARRAY_OF.apply(property.getType());
            String addToMethodName = "addTo" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{property})).addToAttributes("BODY", (Object)("this." + property.getName() + ".clear(); if (" + property.getName() + " != null) {for (" + unwraped.getSimpleName() + " item :" + property.getName() + "){ this." + addToMethodName + "(item);}} return (T) this;"))).build();
        }
    }
    ,
    GETTER{

        public JavaMethod apply(JavaProperty property) {
            String prefix = property.getType().isBoolean() ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            String body = null;
            Set<JavaProperty> descendants = BuilderUtils.getPropertyBuildableAncestors(property);
            if (BuilderUtils.isMap(property.getType())) {
                body = "return this." + property.getName() + ";";
            } else if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                body = BuilderUtils.isList(property.getType()) || BuilderUtils.isSet(property.getType()) ? "return build(" + property.getName() + ");" : "return this." + property.getName() + "!=null?this." + property.getName() + ".build():null;";
            } else if (descendants.size() > 0) {
                if (BuilderUtils.isList(property.getType()) || BuilderUtils.isSet(property.getType())) {
                    JavaType type = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType());
                    String names = StringUtils.join(descendants, (Function)new Function<JavaProperty, String>(){

                        public String apply(JavaProperty item) {
                            return "build(" + item.getName() + ")";
                        }
                    }, (String)", ");
                    body = "return aggregate(" + names + ");";
                } else {
                    body = "return this." + property.getName() + ";";
                }
            } else {
                body = "return this." + property.getName() + ";";
            }
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(property.getType())).withArguments(new JavaProperty[0])).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    GETTER_ARRAY{

        public JavaMethod apply(JavaProperty property) {
            String prefix = property.getType().isBoolean() ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            JavaType type = property.getType();
            JavaType builderType = (JavaType)TypeAs.VISITABLE_BUILDER.apply(type);
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(property.getType())).withArguments(new JavaProperty[0])).addToAttributes("BODY", (Object)String.format(StringUtils.loadResource((String)"snippets/array-getter.txt"), type.getClassName(), builderType.getSimpleName(), property.getName(), type.getClassName()))).build();
        }
    }
    ,
    SETTER{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "set" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(Constants.VOID)).withArguments(new JavaProperty[]{property})).addToAttributes("BODY", (Object)("this." + property.getName() + "=" + property.getName() + ";"))).build();
        }
    }
    ,
    ADD_TO_COLLECTION{

        public JavaMethod apply(JavaProperty property) {
            EditableJavaProperty item = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName("item")).withType((JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType()))).build();
            String methodName = "addTo" + property.getNameCapitalized();
            String body = "";
            Set<JavaProperty> descendants = BuilderUtils.getPropertyBuildableAncestors(property);
            if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                JavaType builder = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.BUILDER).apply((Object)property.getType());
                String builderClass = builder.getSimpleName();
                body = "if (item != null) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.add(builder);this." + property.getName() + ".add(builder);} return (T)this;";
            } else if (descendants.size() > 0) {
                body = StringUtils.join(descendants, (Function)new Function<JavaProperty, String>(){

                    public String apply(JavaProperty item) {
                        JavaType t = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(item.getType());
                        String addToMethodName = "addTo" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + t.getSimpleName() + "){" + addToMethodName + "((" + t.getSimpleName() + ")item);}\n";
                    }
                }, (String)" else ");
                body = body + "return (T)this;";
            } else {
                body = "if (item != null) {this." + property.getName() + ".add(item);} return (T)this;";
            }
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{item})).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    ADD_TO_MAP{

        public JavaMethod apply(JavaProperty property) {
            JavaType mapType = property.getType();
            JavaType keyType = mapType.getGenericTypes()[0];
            JavaType valueType = mapType.getGenericTypes()[1];
            EditableJavaProperty keyProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("key")).withType(keyType)).build();
            EditableJavaProperty valueProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("value")).withType(valueType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{keyProperty, valueProperty})).addToAttributes("BODY", (Object)("if(key != null && value != null) {this." + property.getName() + ".put(key, value);} return (T)this;"))).build();
        }
    }
    ,
    WITH_NEW_NESTED{

        public JavaMethod apply(JavaProperty property) {
            JavaType nestedType = (JavaType)PropertyAs.NESTED_TYPE.apply((Object)property);
            EditableJavaType rewraped = ((JavaTypeBuilder)new JavaTypeBuilder(nestedType).withGenericTypes(new JavaType[]{Constants.T})).build();
            String prefix = property.getType().isCollection() ? "addNew" : "withNew";
            String methodName = prefix + StringUtils.captializeFirst((String)(property.getType().isCollection() ? StringUtils.singularize((String)property.getName()) : property.getName()));
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withReturnType((JavaType)rewraped)).withName(methodName)).addToAttributes("BODY", (Object)("return new " + rewraped.getSimpleName() + "();"))).build();
        }
    }
    ,
    AND{

        public JavaMethod apply(JavaProperty property) {
            String builderName = ((JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType())).getSimpleName("Builder");
            String classPrefix = this.getClassPrefix(property);
            String prefix = property.getType().isCollection() ? "addTo" : "with";
            String withMethodName = prefix + StringUtils.captializeFirst((String)property.getName());
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withReturnType(Constants.N)).withName("and")).addToAttributes("BODY", (Object)("return (N) " + classPrefix + withMethodName + "(builder.build());"))).build();
        }

        private String getClassPrefix(JavaProperty property) {
            Object memberOf = property.getAttributes().get("MEMBER_OF");
            if (memberOf instanceof JavaType) {
                return ((JavaType)memberOf).getClassName() + ".this.";
            }
            return "";
        }
    }
    ,
    END{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "end" + StringUtils.captializeFirst((String)(property.getType().isCollection() ? StringUtils.singularize((String)property.getName()) : property.getName()));
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(Modifier.PUBLIC)).withReturnType(Constants.N)).withName(methodName)).addToAttributes("BODY", (Object)"return and();")).build();
        }
    };

}

