/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.ToMethod;
import io.sundr.builder.internal.functions.ToMethods;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.EditableJavaMethod;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaMethodFluent;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public enum ClazzAs implements Function<JavaClazz, JavaClazz>
{
    FLUENT{

        public JavaClazz apply(JavaClazz item) {
            LinkedHashSet<Object> methods = new LinkedHashSet<Object>();
            LinkedHashSet<Object> nestedClazzes = new LinkedHashSet<Object>();
            LinkedHashSet<Object> properties = new LinkedHashSet<Object>();
            JavaType fluentType = (JavaType)TypeAs.FLUENT.apply(item.getType());
            Iterator i$ = item.getFields().iterator();
            while (i$.hasNext()) {
                JavaProperty property;
                JavaProperty toAdd = property = (JavaProperty)i$.next();
                boolean buildable = (Boolean)property.getType().getAttributes().get("BUILDABLE");
                if (property.isArray()) {
                    JavaProperty asList = ClazzAs.arrayAsList(property, buildable);
                    methods.add(ToMethod.WITH_ARRAY.apply(property));
                    methods.add(ToMethod.GETTER_ARRAY.apply(property));
                    methods.add(ToMethod.ADD_TO_COLLECTION.apply(asList));
                    toAdd = asList;
                } else if (BuilderUtils.isSet(property.getType()) || BuilderUtils.isList(property.getType())) {
                    methods.add(ToMethod.ADD_TO_COLLECTION.apply(toAdd));
                    methods.add(ToMethod.GETTER.apply(toAdd));
                    methods.add(ToMethod.WITH.apply(toAdd));
                } else if (BuilderUtils.isMap(property.getType())) {
                    methods.add(ToMethod.ADD_TO_MAP.apply(toAdd));
                    methods.add(ToMethod.GETTER.apply(toAdd));
                    methods.add(ToMethod.WITH.apply(toAdd));
                } else {
                    toAdd = ((JavaPropertyBuilder)new JavaPropertyBuilder(property).addToAttributes("BUILDABLE", (Object)buildable)).build();
                    methods.add(ToMethod.GETTER.apply(toAdd));
                    methods.add(ToMethod.WITH.apply(toAdd));
                }
                Set<JavaProperty> descendants = BuilderUtils.getPropertyBuildableAncestors(toAdd);
                if (BuilderUtils.isMap(toAdd.getType())) {
                    properties.add(toAdd);
                    continue;
                }
                if (BuilderUtils.isBuildable((AttributeSupport)toAdd)) {
                    methods.add(ToMethod.WITH_NEW_NESTED.apply(toAdd));
                    methods.addAll((Collection)ToMethods.WITH_NESTED_INLINE.apply(toAdd));
                    nestedClazzes.add(PropertyAs.NESTED_CLASS.apply((Object)((JavaPropertyBuilder)new JavaPropertyBuilder(toAdd).addToAttributes("MEMBER_OF", (Object)fluentType)).build()));
                    JavaType builderType = (JavaType)TypeAs.VISITABLE_BUILDER.apply(toAdd.getType());
                    if (toAdd.getType().isCollection()) {
                        builderType = TypeUtils.typeGenericOf((JavaType)toAdd.getType(), (JavaType[])new JavaType[]{builderType});
                    }
                    properties.add(((JavaPropertyBuilder)new JavaPropertyBuilder(toAdd).withType(builderType)).build());
                    continue;
                }
                if (descendants.size() > 0 && toAdd.getType().isCollection()) {
                    properties.add(toAdd);
                    for (JavaProperty descendant : descendants) {
                        if (descendant.getType().isCollection()) {
                            methods.add(ToMethod.ADD_TO_COLLECTION.apply(descendant));
                        }
                        methods.add(ToMethod.WITH_NEW_NESTED.apply(descendant));
                        methods.addAll((Collection)ToMethods.WITH_NESTED_INLINE.apply(descendant));
                        nestedClazzes.add(PropertyAs.NESTED_CLASS.apply((Object)((JavaPropertyBuilder)new JavaPropertyBuilder(descendant).addToAttributes("MEMBER_OF", (Object)fluentType)).build()));
                        JavaType builderType = (JavaType)TypeAs.VISITABLE_BUILDER.apply(descendant.getType());
                        if (descendant.getType().isCollection()) {
                            builderType = TypeUtils.typeGenericOf((JavaType)descendant.getType(), (JavaType[])new JavaType[]{builderType});
                        }
                        properties.add(((JavaPropertyBuilder)new JavaPropertyBuilder(descendant).withType(builderType)).build());
                    }
                    continue;
                }
                properties.add(toAdd);
            }
            return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder(item).withType(fluentType)).withFields(properties)).withNested(nestedClazzes)).withMethods(methods)).build();
        }
    }
    ,
    BUILDER{

        public JavaClazz apply(JavaClazz item) {
            JavaType builderType = (JavaType)TypeAs.BUILDER.apply(item.getType());
            JavaType fluent = (JavaType)TypeAs.GENERIC_FLUENT.apply(item.getType());
            LinkedHashSet<EditableJavaMethod> constructors = new LinkedHashSet<EditableJavaMethod>();
            LinkedHashSet<EditableJavaMethod> methods = new LinkedHashSet<EditableJavaMethod>();
            LinkedHashSet<EditableJavaProperty> fields = new LinkedHashSet<EditableJavaProperty>();
            EditableJavaProperty fluentProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withType(fluent)).withName("fluent")).build();
            fields.add(fluentProperty);
            EditableJavaMethod emptyConstructor = ((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(builderType)).addToAttributes("BODY", (Object)(BuilderUtils.hasDefaultConstructor(item) ? "this(new " + item.getType().getClassName() + "());" : "this.fluent = this;"))).build();
            EditableJavaMethod fluentConstructor = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(builderType)).addNewArgument().withType(fluent)).withName("fluent")).and()).addToAttributes("BODY", (Object)(BuilderUtils.hasDefaultConstructor(item) ? "this(fluent, new " + item.getType().getClassName() + "());" : "this.fluent = fluent;"))).build();
            EditableJavaMethod instanceAndFluentCosntructor = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(builderType)).addNewArgument().withType(fluent)).withName("fluent")).and()).addNewArgument().withType(item.getType())).withName("instance")).and()).addToAttributes("BODY", (Object)ClazzAs.toInstanceConstructorBody(item, "fluent"))).build();
            EditableJavaMethod instanceConstructor = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(builderType)).addNewArgument().withType(item.getType())).withName("instance")).and()).addToAttributes("BODY", (Object)ClazzAs.toInstanceConstructorBody(item, "this"))).build();
            constructors.add(emptyConstructor);
            constructors.add(fluentConstructor);
            constructors.add(instanceAndFluentCosntructor);
            constructors.add(instanceConstructor);
            EditableJavaMethod build = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(item.getType())).withName("build")).addToAttributes("BODY", (Object)ClazzAs.toBuild(item))).build();
            methods.add(build);
            return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder(item).withType(builderType)).withFields(fields)).withConstructors(constructors)).withMethods(methods)).build();
        }
    }
    ,
    EDITABLE_BUILDER{

        public JavaClazz apply(JavaClazz item) {
            JavaClazz builder = (JavaClazz)BUILDER.apply(item);
            LinkedHashSet<Object> methods = new LinkedHashSet<Object>();
            for (JavaMethod m : builder.getMethods()) {
                if (m.getName().equals("build")) {
                    methods.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType((JavaType)TypeAs.EDITABLE.apply(m.getReturnType()))).withName("build")).addToAttributes("BODY", (Object)ClazzAs.toBuild((JavaClazz)3.EDITABLE.apply(item)))).build());
                    continue;
                }
                methods.add(m);
            }
            return ((JavaClazzBuilder)new JavaClazzBuilder(builder).withMethods(methods)).build();
        }
    }
    ,
    EDITABLE{

        public JavaClazz apply(JavaClazz item) {
            JavaType type = item.getType();
            JavaType editableType = (JavaType)TypeAs.EDITABLE.apply(type);
            JavaType builderType = (JavaType)TypeAs.BUILDER.apply(type);
            LinkedHashSet<JavaMethod> constructors = new LinkedHashSet<JavaMethod>();
            LinkedHashSet<EditableJavaMethod> methods = new LinkedHashSet<EditableJavaMethod>();
            for (JavaMethod constructor : item.getConstructors()) {
                constructors.add(ClazzAs.superConstructorOf(constructor, editableType));
            }
            EditableJavaMethod edit = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(builderType)).withName("edit")).addToAttributes("BODY", (Object)("return new " + builderType.getSimpleName() + "(this);"))).build();
            methods.add(edit);
            return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder().withType(editableType)).withConstructors(constructors)).withMethods(methods)).build();
        }
    };


    private static JavaProperty arrayAsList(JavaProperty property, boolean buildable) {
        return ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withArray(false)).withType((JavaType)TypeAs.ARRAY_AS_LIST.apply(property.getType()))).addToAttributes("BUILDABLE", (Object)buildable)).build();
    }

    private static String toInstanceConstructorBody(JavaClazz clazz, String fluent) {
        JavaMethod constructor = BuilderUtils.findBuildableConstructor(clazz);
        StringBuilder sb = new StringBuilder();
        sb.append("this.fluent = " + fluent + "; ");
        for (JavaProperty property : constructor.getArguments()) {
            JavaMethod getter = BuilderUtils.findGetter(clazz, property);
            sb.append(fluent).append(".with").append(property.getNameCapitalized()).append("(instance.").append(getter.getName()).append("()); ");
        }
        return sb.toString();
    }

    private static String toBuild(JavaClazz clazz) {
        JavaMethod constructor = BuilderUtils.findBuildableConstructor(clazz);
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getType().getSimpleName()).append(" buildable = new ").append(clazz.getType().getSimpleName()).append("(");
        sb.append(StringUtils.join((Object[])constructor.getArguments(), (Function)new Function<JavaProperty, String>(){

            public String apply(JavaProperty item) {
                String prefix = item.getType().isBoolean() ? "is" : "get";
                return "fluent." + prefix + item.getNameCapitalized() + "()";
            }
        }, (String)","));
        sb.append(");\n");
        sb.append("validate(buildable);\n");
        sb.append("return buildable;\n");
        return sb.toString();
    }

    private static JavaMethod superConstructorOf(JavaMethod constructor, JavaType constructorType) {
        return ((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder(constructor).withReturnType(constructorType)).addToAttributes("BODY", (Object)("super(" + StringUtils.join((Object[])constructor.getArguments(), (Function)new Function<JavaProperty, String>(){

            public String apply(JavaProperty item) {
                return item.getName();
            }
        }, (String)", ") + ");"))).build();
    }
}

