/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.k8s;

import io.fabric8.elasticsearch.discovery.k8s.K8sUnicastHostsProvider;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class K8sDiscovery
extends ZenDiscovery {
    @Inject
    public K8sDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, ZenPingService pingService, DiscoveryNodeService discoveryNodeService, NetworkService networkService, DiscoverySettings discoverySettings, ElectMasterService electMasterService, DynamicSettings dynamicSettings) {
        super(settings, clusterName, threadPool, transportService, clusterService, nodeSettingsService, discoveryNodeService, pingService, electMasterService, discoverySettings, dynamicSettings);
        if (settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true)).booleanValue()) {
            ImmutableList zenPings = pingService.zenPings();
            UnicastZenPing unicastZenPing = null;
            for (ZenPing zenPing : zenPings) {
                if (!(zenPing instanceof UnicastZenPing)) continue;
                unicastZenPing = (UnicastZenPing)zenPing;
                break;
            }
            if (unicastZenPing != null) {
                unicastZenPing.addHostsProvider((UnicastHostsProvider)new K8sUnicastHostsProvider(settings, transportService, networkService));
                pingService.zenPings(ImmutableList.of((Object)unicastZenPing));
            } else {
                this.logger.warn("failed to apply gce unicast discovery, no unicast ping found", new Object[0]);
            }
        }
    }
}

