/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class UriBuilderImpl
extends UriBuilder
implements Cloneable {
    private String scheme;
    private String userInfo;
    private int port = -1;
    private String host;
    private List<PathSegment> paths = new ArrayList<PathSegment>();
    private boolean originalPathEmpty;
    private boolean leadingSlash;
    private String fragment;
    private String schemeSpecificPart;
    private MultivaluedMap<String, String> query = new MetadataMap<String, String>();
    private MultivaluedMap<String, String> matrix = new MetadataMap<String, String>();
    private Map<String, Object> resolvedTemplates;
    private Map<String, Object> resolvedTemplatesPathEnc;
    private Map<String, Object> resolvedEncodedTemplates;

    public UriBuilderImpl() {
    }

    public UriBuilderImpl(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.doBuild(false, true, values);
    }

    private static Map<String, Object> getResolvedTemplates(Map<String, Object> rtemplates) {
        return rtemplates == null ? Collections.emptyMap() : new LinkedHashMap<String, Object>(rtemplates);
    }

    private URI doBuild(boolean fromEncoded, boolean encodePathSlash, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Template parameter values are set to null");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new IllegalArgumentException("Template parameter value is set to null");
        }
        UriParts parts = this.doBuildUriParts(fromEncoded, encodePathSlash, false, values);
        try {
            return this.buildURI(fromEncoded, parts.path, parts.query, parts.fragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private UriParts doBuildUriParts(boolean fromEncoded, boolean encodePathSlash, boolean allowUnresolved, Object ... values) {
        URITemplate fragmentTempl;
        String theFragment;
        URITemplate queryTempl;
        Map<String, Object> alreadyResolvedTs = UriBuilderImpl.getResolvedTemplates(this.resolvedTemplates);
        Map<String, Object> alreadyResolvedTsPathEnc = UriBuilderImpl.getResolvedTemplates(this.resolvedTemplatesPathEnc);
        Map<String, Object> alreadyResolvedEncTs = UriBuilderImpl.getResolvedTemplates(this.resolvedEncodedTemplates);
        int resolvedTsSize = alreadyResolvedTs.size() + alreadyResolvedEncTs.size() + alreadyResolvedTsPathEnc.size();
        String thePath = this.buildPath();
        URITemplate pathTempl = new URITemplate(thePath);
        thePath = this.substituteVarargs(pathTempl, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, values, 0, false, fromEncoded, allowUnresolved, encodePathSlash);
        int pathTemplateVarsSize = pathTempl.getVariables().size();
        String theQuery = this.buildQuery();
        int queryTemplateVarsSize = 0;
        if (theQuery != null && (queryTemplateVarsSize = (queryTempl = new URITemplate(theQuery)).getVariables().size()) > 0) {
            int lengthDiff = values.length + resolvedTsSize - alreadyResolvedTs.size() - alreadyResolvedTsPathEnc.size() - alreadyResolvedEncTs.size() - pathTemplateVarsSize;
            theQuery = this.substituteVarargs(queryTempl, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, values, values.length - lengthDiff, true, fromEncoded, allowUnresolved, false);
        }
        if ((theFragment = this.fragment) != null && (fragmentTempl = new URITemplate(theFragment)).getVariables().size() > 0) {
            int lengthDiff = values.length + resolvedTsSize - alreadyResolvedTs.size() - alreadyResolvedTsPathEnc.size() - alreadyResolvedEncTs.size() - pathTemplateVarsSize - queryTemplateVarsSize;
            theFragment = this.substituteVarargs(fragmentTempl, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, values, values.length - lengthDiff, true, fromEncoded, allowUnresolved, false);
        }
        return new UriParts(thePath, theQuery, theFragment);
    }

    private URI buildURI(boolean fromEncoded, String thePath, String theQuery, String theFragment) throws URISyntaxException {
        if (fromEncoded) {
            return this.buildURIFromEncoded(thePath, theQuery, theFragment);
        }
        if (!this.isSchemeOpaque()) {
            if (!(this.scheme == null && this.host == null && this.userInfo == null || thePath.length() == 0 || thePath.startsWith("/") || thePath.startsWith(";"))) {
                thePath = "/" + thePath;
            }
            try {
                return this.buildURIFromEncoded(thePath, theQuery, theFragment);
            }
            catch (Exception ex) {
                URI uri = new URI(this.scheme, this.userInfo, this.host, this.port, thePath, theQuery, theFragment);
                if (thePath.contains("%2F")) {
                    String realPath = uri.getRawPath().replace("%252F", "%2F");
                    uri = this.buildURIFromEncoded(realPath, uri.getRawQuery(), uri.getRawFragment());
                }
                return uri;
            }
        }
        return new URI(this.scheme, this.schemeSpecificPart, theFragment);
    }

    private URI buildURIFromEncoded(String thePath, String theQuery, String theFragment) throws URISyntaxException {
        return new URI(this.buildUriString(thePath, theQuery, theFragment));
    }

    private String buildUriString(String thePath, String theQuery, String theFragment) {
        StringBuilder b = new StringBuilder();
        if (this.scheme != null) {
            b.append(this.scheme).append(":");
        }
        if (!this.isSchemeOpaque()) {
            if (this.scheme != null) {
                b.append("//");
            }
            if (this.userInfo != null) {
                b.append(this.userInfo).append('@');
            }
            if (this.host != null) {
                b.append(this.host);
            }
            if (this.port != -1) {
                b.append(':').append(this.port);
            }
            if (thePath != null && thePath.length() > 0) {
                b.append(thePath.startsWith("/") || b.length() == 0 || this.originalPathEmpty ? thePath : '/' + thePath);
            }
            if (theQuery != null && theQuery.length() != 0) {
                b.append('?').append(theQuery);
            }
        } else {
            b.append(this.schemeSpecificPart);
        }
        if (theFragment != null) {
            b.append('#').append(theFragment);
        }
        return b.toString();
    }

    private boolean isSchemeOpaque() {
        return this.schemeSpecificPart != null;
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.doBuild(true, false, values);
    }

    public URI buildFromMap(Map<String, ?> map) throws IllegalArgumentException, UriBuilderException {
        return this.doBuildFromMap(map, false, true);
    }

    private URI doBuildFromMap(Map<String, ? extends Object> map, boolean fromEncoded, boolean encodePathSlash) throws IllegalArgumentException, UriBuilderException {
        try {
            Map<String, Object> alreadyResolvedTs = UriBuilderImpl.getResolvedTemplates(this.resolvedTemplates);
            Map<String, Object> alreadyResolvedTsPathEnc = UriBuilderImpl.getResolvedTemplates(this.resolvedTemplatesPathEnc);
            Map<String, Object> alreadyResolvedEncTs = UriBuilderImpl.getResolvedTemplates(this.resolvedEncodedTemplates);
            String thePath = this.buildPath();
            thePath = this.substituteMapped(thePath, map, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, false, fromEncoded, encodePathSlash);
            String theQuery = this.buildQuery();
            if (theQuery != null) {
                theQuery = this.substituteMapped(theQuery, map, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, true, fromEncoded, false);
            }
            String theFragment = this.fragment == null ? null : this.substituteMapped(this.fragment, map, alreadyResolvedTs, alreadyResolvedTsPathEnc, alreadyResolvedEncTs, true, fromEncoded, encodePathSlash);
            return this.buildURI(fromEncoded, thePath, theQuery, theFragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private String substituteVarargs(URITemplate templ, Map<String, Object> alreadyResolvedTs, Map<String, Object> alreadyResolvedTsPathEnc, Map<String, Object> alreadyResolvedTsEnc, Object[] values, int ind, boolean isQuery, boolean fromEncoded, boolean allowUnresolved, boolean encodePathSlash) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        LinkedHashSet<String> uniqueVars = new LinkedHashSet<String>(templ.getVariables());
        if (!allowUnresolved && values.length + alreadyResolvedTs.size() + alreadyResolvedTsEnc.size() + alreadyResolvedTsPathEnc.size() < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + values.length + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        int idx = ind;
        HashSet<String> pathEncodeVars = alreadyResolvedTsPathEnc.isEmpty() && !encodePathSlash ? Collections.emptySet() : new HashSet();
        for (String var : uniqueVars) {
            boolean varValueHasToBeEncoded;
            boolean resolvedPathVarHasToBeEncoded = !isQuery && alreadyResolvedTsPathEnc.containsKey(var);
            boolean bl = varValueHasToBeEncoded = resolvedPathVarHasToBeEncoded || alreadyResolvedTs.containsKey(var);
            Map<String, Object> resolved = !varValueHasToBeEncoded ? alreadyResolvedTsEnc : (resolvedPathVarHasToBeEncoded ? alreadyResolvedTsPathEnc : alreadyResolvedTs);
            Object oval = resolved.isEmpty() ? null : resolved.remove(var);
            boolean valueFromEncodedMap = false;
            if (oval == null) {
                if (allowUnresolved) continue;
                oval = values[idx++];
            } else {
                boolean bl2 = valueFromEncodedMap = resolved == alreadyResolvedTsEnc;
            }
            if (oval == null) {
                throw new IllegalArgumentException("No object for " + var);
            }
            String value = oval.toString();
            value = fromEncoded || valueFromEncodedMap ? HttpUtils.encodePartiallyEncoded(value, isQuery) : (isQuery ? HttpUtils.queryEncode(value) : HttpUtils.pathEncode(value));
            varValueMap.put(var, value);
            if (isQuery || !resolvedPathVarHasToBeEncoded && (!encodePathSlash || varValueHasToBeEncoded)) continue;
            pathEncodeVars.add(var);
        }
        return templ.substitute(varValueMap, pathEncodeVars, allowUnresolved);
    }

    private String substituteMapped(String path, Map<String, ? extends Object> varValueMap, Map<String, Object> alreadyResolvedTs, Map<String, Object> alreadyResolvedTsPathEnc, Map<String, Object> alreadyResolvedTsEnc, boolean isQuery, boolean fromEncoded, boolean encodePathSlash) {
        URITemplate templ = new URITemplate(path);
        HashSet<String> uniqueVars = new HashSet<String>(templ.getVariables());
        if (varValueMap.size() + alreadyResolvedTs.size() + alreadyResolvedTsEnc.size() + alreadyResolvedTsPathEnc.size() < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + varValueMap.size() + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        HashSet<String> pathEncodeVars = alreadyResolvedTsPathEnc.isEmpty() && !encodePathSlash ? Collections.emptySet() : new HashSet();
        LinkedHashMap<String, Object> theMap = new LinkedHashMap<String, Object>();
        for (String var : uniqueVars) {
            Object oval;
            boolean isVarEncoded;
            boolean isPathEncVar = !isQuery && alreadyResolvedTsPathEnc.containsKey(var);
            boolean bl = isVarEncoded = !isPathEncVar && !alreadyResolvedTs.containsKey(var);
            Map<String, Object> resolved = isVarEncoded ? alreadyResolvedTsEnc : (isPathEncVar ? alreadyResolvedTsPathEnc : alreadyResolvedTs);
            Object object = oval = resolved.isEmpty() ? null : resolved.remove(var);
            if (oval == null) {
                oval = varValueMap.get(var);
            }
            if (oval == null) {
                throw new IllegalArgumentException("No object for " + var);
            }
            oval = fromEncoded ? HttpUtils.encodePartiallyEncoded(oval.toString(), isQuery) : (isQuery ? HttpUtils.queryEncode(oval.toString()) : HttpUtils.pathEncode(oval.toString()));
            theMap.put(var, oval);
            if (isQuery || !isPathEncVar && !encodePathSlash) continue;
            pathEncodeVars.add(var);
        }
        return templ.substitute(theMap, pathEncodeVars, false);
    }

    public URI buildFromEncodedMap(Map<String, ?> map) throws IllegalArgumentException, UriBuilderException {
        HashMap<String, String> decodedMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Value is null");
            }
            String theValue = entry.getValue().toString();
            if (theValue.contains("/")) {
                StringBuilder buf = new StringBuilder();
                String[] values = StringUtils.split((String)theValue, (String)"/");
                for (int i = 0; i < values.length; ++i) {
                    buf.append(HttpUtils.encodePartiallyEncoded(values[i], false));
                    if (i + 1 >= values.length) continue;
                    buf.append("/");
                }
                decodedMap.put(entry.getKey(), buf.toString());
                continue;
            }
            decodedMap.put(entry.getKey(), HttpUtils.encodePartiallyEncoded(theValue, false));
        }
        return this.doBuildFromMap(decodedMap, true, false);
    }

    public UriBuilder clone() {
        UriBuilderImpl builder = new UriBuilderImpl();
        builder.scheme = this.scheme;
        builder.userInfo = this.userInfo;
        builder.port = this.port;
        builder.host = this.host;
        builder.paths = new ArrayList<PathSegment>(this.paths);
        builder.fragment = this.fragment;
        builder.query = new MetadataMap<String, String>((Map<String, List<String>>)this.query);
        builder.matrix = new MetadataMap<String, String>((Map<String, List<String>>)this.matrix);
        builder.schemeSpecificPart = this.schemeSpecificPart;
        builder.leadingSlash = this.leadingSlash;
        builder.originalPathEmpty = this.originalPathEmpty;
        builder.resolvedEncodedTemplates = this.resolvedEncodedTemplates == null ? null : new HashMap<String, Object>(this.resolvedEncodedTemplates);
        builder.resolvedTemplates = this.resolvedTemplates == null ? null : new HashMap<String, Object>(this.resolvedTemplates);
        builder.resolvedTemplatesPathEnc = this.resolvedTemplatesPathEnc == null ? null : new HashMap<String, Object>(this.resolvedTemplatesPathEnc);
        return builder;
    }

    public UriBuilder fragment(String theFragment) throws IllegalArgumentException {
        this.fragment = theFragment;
        return this;
    }

    public UriBuilder host(String theHost) throws IllegalArgumentException {
        if ("".equals(theHost)) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        this.host = theHost;
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        Class cls = resource;
        Path ann = cls.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Class '" + resource.getCanonicalName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path foundAnn = null;
        for (Method meth : resource.getMethods()) {
            if (!meth.getName().equals(method)) continue;
            Path ann = meth.getAnnotation(Path.class);
            if (foundAnn != null && ann != null) {
                throw new IllegalArgumentException("Multiple Path annotations for '" + method + "' overloaded method");
            }
            foundAnn = ann;
        }
        if (foundAnn == null) {
            throw new IllegalArgumentException("No Path annotation for '" + method + "' method");
        }
        return this.path(foundAnn.value());
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path ann = method.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Method '" + method.getClass().getCanonicalName() + "." + method.getName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(String path) throws IllegalArgumentException {
        return this.doPath(path, true);
    }

    private UriBuilder doPath(String path, boolean checkSegments) {
        List<Object> segments;
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (this.isAbsoluteUriPath(path)) {
            try {
                URI uri = URI.create(path);
                this.originalPathEmpty = StringUtils.isEmpty((String)uri.getPath());
                this.uri(uri);
            }
            catch (IllegalArgumentException ex) {
                int pathComponentStart;
                if (!new URITemplate(path).getVariables().isEmpty()) {
                    return this.uriAsTemplate(path);
                }
                String pathEncoded = HttpUtils.pathEncode(path);
                int schemeIndex = pathEncoded.indexOf("//");
                if (schemeIndex != -1 && (pathComponentStart = pathEncoded.indexOf("/", schemeIndex + 2)) == -1) {
                    this.originalPathEmpty = true;
                    pathComponentStart = pathEncoded.indexOf(";");
                    if (pathComponentStart != -1) {
                        pathEncoded = pathEncoded.substring(0, pathComponentStart) + "/" + pathEncoded.substring(pathComponentStart);
                    }
                }
                this.setUriParts(URI.create(pathEncoded));
            }
            return this;
        }
        if (this.paths.isEmpty()) {
            this.leadingSlash = path.startsWith("/");
        }
        if (checkSegments) {
            segments = JAXRSUtils.getPathSegments(path, false, false);
        } else {
            segments = new ArrayList();
            path = path.replaceAll("/", "%2F");
            segments.add(new PathSegmentImpl(path, false));
        }
        if (!this.paths.isEmpty() && !this.matrix.isEmpty()) {
            PathSegment ps = this.paths.remove(this.paths.size() - 1);
            this.paths.add(this.replacePathSegment(ps));
        }
        this.paths.addAll(segments);
        this.matrix.clear();
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        }
        return this;
    }

    public UriBuilder port(int thePort) throws IllegalArgumentException {
        if (thePort < 0 && thePort != -1) {
            throw new IllegalArgumentException("Port cannot be negative");
        }
        this.port = thePort;
        return this;
    }

    public UriBuilder scheme(String s) throws IllegalArgumentException {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        try {
            if (this.scheme == null) {
                this.scheme = "http";
            }
            URI uri = new URI(this.scheme, ssp, this.fragment);
            this.setUriParts(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Wrong syntax of scheme-specific part", e);
        }
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
        return this;
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    private void setUriParts(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        String theScheme = uri.getScheme();
        if (theScheme != null) {
            this.scheme = theScheme;
        }
        String rawPath = uri.getRawPath();
        if (!uri.isOpaque() && (theScheme != null || rawPath != null && rawPath.startsWith("/"))) {
            String rawQuery;
            this.port = uri.getPort();
            this.host = uri.getHost();
            if (rawPath != null) {
                this.setPathAndMatrix(rawPath);
            }
            if ((rawQuery = uri.getRawQuery()) != null) {
                this.query = JAXRSUtils.getStructuredParams(rawQuery, "&", false, false);
            }
            this.userInfo = uri.getUserInfo();
            this.schemeSpecificPart = null;
        } else {
            this.schemeSpecificPart = uri.getSchemeSpecificPart();
        }
        String theFragment = uri.getFragment();
        if (theFragment != null) {
            this.fragment = theFragment;
        }
    }

    private void setPathAndMatrix(String path) {
        this.leadingSlash = !this.originalPathEmpty && path.startsWith("/");
        this.paths = JAXRSUtils.getPathSegments(path, false, false);
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        } else {
            this.matrix.clear();
        }
    }

    private String buildPath() {
        StringBuilder sb = new StringBuilder();
        Iterator<PathSegment> iter = this.paths.iterator();
        while (iter.hasNext()) {
            PathSegment ps = iter.next();
            String p = ps.getPath();
            if (p.length() == 0 && iter.hasNext()) continue;
            p = new URITemplate(p).encodeLiteralCharacters(false);
            if (sb.length() == 0 && this.leadingSlash) {
                sb.append('/');
            } else if (!p.startsWith("/") && sb.length() > 0) {
                sb.append('/');
            }
            sb.append(p);
            if (!iter.hasNext()) continue;
            this.buildMatrix(sb, (MultivaluedMap<String, String>)ps.getMatrixParameters());
        }
        this.buildMatrix(sb, this.matrix);
        return sb.toString();
    }

    private String buildQuery() {
        return this.buildParams(this.query, '&');
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null || values == null) {
            throw new IllegalArgumentException("name or values is null");
        }
        List list = (List)this.matrix.get((Object)name);
        if (list == null) {
            this.matrix.put((Object)name, this.toStringList(values));
        } else {
            list.addAll(this.toStringList(values));
        }
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null || values == null) {
            throw new IllegalArgumentException("name or values is null");
        }
        List list = (List)this.query.get((Object)name);
        if (list == null) {
            this.query.put((Object)name, this.toStringList(values));
        } else {
            list.addAll(this.toStringList(values));
        }
        return this;
    }

    public UriBuilder replaceMatrix(String matrixValues) throws IllegalArgumentException {
        String encodedMatrixValues = matrixValues != null ? HttpUtils.pathEncode(matrixValues) : null;
        this.matrix = JAXRSUtils.getStructuredParams(encodedMatrixValues, ";", true, false);
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values != null && values.length >= 1 && values[0] != null) {
            this.matrix.put((Object)name, this.toStringList(values));
        } else {
            this.matrix.remove((Object)name);
        }
        return this;
    }

    public UriBuilder replacePath(String path) {
        if (path == null) {
            this.clearPathAndMatrix();
        } else if (this.isAbsoluteUriPath(path)) {
            this.clearPathAndMatrix();
            this.uri(URI.create(path));
        } else {
            this.setPathAndMatrix(path);
        }
        return this;
    }

    private void clearPathAndMatrix() {
        this.paths.clear();
        this.matrix.clear();
    }

    private boolean isAbsoluteUriPath(String path) {
        return path.startsWith("http:") || path.startsWith("https:");
    }

    public UriBuilder replaceQuery(String queryValue) throws IllegalArgumentException {
        if (queryValue != null) {
            queryValue = queryValue.replace(" ", "%20");
        }
        this.query = JAXRSUtils.getStructuredParams(queryValue, "&", false, true);
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values != null && values.length >= 1 && values[0] != null) {
            this.query.put((Object)name, this.toStringList(values));
        } else {
            this.query.remove((Object)name);
        }
        return this;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("Segments should not be null");
        }
        for (String segment : segments) {
            this.doPath(segment, false);
        }
        return this;
    }

    private List<String> toStringList(Object ... values) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) {
                    throw new IllegalArgumentException("Null value on " + i + " position");
                }
                list.add(value.toString());
            }
        }
        if (list.isEmpty()) {
            list.add("");
        }
        return list;
    }

    private String buildParams(MultivaluedMap<String, String> map, char separator) {
        boolean isQuery = separator == '&';
        StringBuilder b = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Iterator sit = ((List)entry.getValue()).iterator();
            while (sit.hasNext()) {
                String val = (String)sit.next();
                boolean templateValue = val.startsWith("{") && val.endsWith("}");
                val = !templateValue ? HttpUtils.encodePartiallyEncoded(val, isQuery) : new URITemplate(val).encodeLiteralCharacters(isQuery);
                b.append((String)entry.getKey());
                if (val.length() != 0) {
                    b.append('=').append(val);
                }
                if (!sit.hasNext() && !it.hasNext()) continue;
                b.append(separator);
            }
        }
        return b.length() > 0 ? b.toString() : null;
    }

    private void buildMatrix(StringBuilder sb, MultivaluedMap<String, String> map) {
        if (!map.isEmpty()) {
            sb.append(';');
            sb.append(this.buildParams(map, ';'));
        }
    }

    private PathSegment replacePathSegment(PathSegment ps) {
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        this.buildMatrix(sb, this.matrix);
        return new PathSegmentImpl(sb.toString());
    }

    public UriBuilder uri(String uriTemplate) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)uriTemplate)) {
            throw new IllegalArgumentException();
        }
        try {
            return this.uri(URI.create(uriTemplate));
        }
        catch (Exception ex) {
            if (new URITemplate(uriTemplate).getVariables().isEmpty()) {
                throw new IllegalArgumentException(ex);
            }
            return this.uriAsTemplate(uriTemplate);
        }
    }

    public UriBuilder uriAsTemplate(String uri) {
        int index = uri.indexOf(":");
        if (index != -1) {
            this.scheme = uri.substring(0, index);
            if ((uri = uri.substring(index + 1)).indexOf("//") == 0) {
                index = (uri = uri.substring(2)).indexOf("/");
                if (index != -1) {
                    String[] schemePair = uri.substring(0, index).split(":");
                    this.host = schemePair[0];
                    this.port = schemePair.length == 2 ? Integer.valueOf(schemePair[1]) : -1;
                }
                uri = uri.substring(index);
            }
        }
        this.setPathAndMatrix(uri);
        return this;
    }

    public URI build(Object[] vars, boolean encodePathSlash) throws IllegalArgumentException, UriBuilderException {
        return this.doBuild(false, encodePathSlash, vars);
    }

    public URI buildFromMap(Map<String, ?> map, boolean encodePathSlash) throws IllegalArgumentException, UriBuilderException {
        return this.doBuildFromMap(map, false, encodePathSlash);
    }

    public String toTemplate() {
        UriParts parts = this.doBuildUriParts(false, false, true, new Object[0]);
        return this.buildUriString(parts.path, parts.query, parts.fragment);
    }

    public UriBuilder resolveTemplate(String name, Object value) throws IllegalArgumentException {
        return this.resolveTemplate(name, value, true);
    }

    public UriBuilder resolveTemplate(String name, Object value, boolean encodePathSlash) throws IllegalArgumentException {
        return this.resolveTemplates(Collections.singletonMap(name, value), encodePathSlash);
    }

    public UriBuilder resolveTemplates(Map<String, Object> values) throws IllegalArgumentException {
        return this.resolveTemplates(values, true);
    }

    public UriBuilder resolveTemplates(Map<String, Object> values, boolean encodePathSlash) throws IllegalArgumentException {
        if (encodePathSlash) {
            this.resolvedTemplatesPathEnc = UriBuilderImpl.fillInResolveTemplates(this.resolvedTemplatesPathEnc, values);
        } else {
            this.resolvedTemplates = UriBuilderImpl.fillInResolveTemplates(this.resolvedTemplates, values);
        }
        return this;
    }

    public UriBuilder resolveTemplateFromEncoded(String name, Object value) throws IllegalArgumentException {
        return this.resolveTemplatesFromEncoded(Collections.singletonMap(name, value));
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> values) throws IllegalArgumentException {
        this.resolvedEncodedTemplates = UriBuilderImpl.fillInResolveTemplates(this.resolvedEncodedTemplates, values);
        return this;
    }

    private static Map<String, Object> fillInResolveTemplates(Map<String, Object> map, Map<String, Object> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException();
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private class UriParts {
        String path;
        String query;
        String fragment;

        public UriParts(String path, String query, String fragment) {
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }
    }
}

