/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.InputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class ContainerRequestContextImpl
extends AbstractRequestContextImpl
implements ContainerRequestContext {
    private static final String ENDPOINT_ADDRESS_PROPERTY = "org.apache.cxf.transport.endpoint.address";
    private boolean preMatch;

    public ContainerRequestContextImpl(Message message, boolean preMatch, boolean responseContext) {
        super(message, responseContext);
        this.preMatch = preMatch;
    }

    public InputStream getEntityStream() {
        return (InputStream)this.m.getContent(InputStream.class);
    }

    public Request getRequest() {
        return new RequestImpl(this.m);
    }

    public SecurityContext getSecurityContext() {
        SecurityContext sc = (SecurityContext)this.m.get(SecurityContext.class);
        return sc == null ? new SecurityContextImpl(this.m) : sc;
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl(this.m);
    }

    public boolean hasEntity() {
        InputStream is = this.getEntityStream();
        return is != null && !"GET".equals(this.getMethod());
    }

    public void setEntityStream(InputStream is) {
        this.checkContext();
        this.m.setContent(InputStream.class, (Object)is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders(this.m);
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        if (requestUri.isAbsolute()) {
            String baseUriString = new UriInfoImpl(this.m).getBaseUri().toString();
            String requestUriString = requestUri.toString();
            if (!requestUriString.startsWith(baseUriString)) {
                this.setRequestUri(requestUri, URI.create("/"));
                return;
            }
            if ((requestUriString = requestUriString.substring(baseUriString.length())).isEmpty()) {
                requestUriString = "/";
            }
            requestUri = URI.create(requestUriString);
        }
        this.doSetRequestUri(requestUri);
    }

    public void doSetRequestUri(URI requestUri) throws IllegalStateException {
        this.checkNotPreMatch();
        HttpUtils.resetRequestURI(this.m, requestUri.toString());
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.doSetRequestUri(requestUri);
        Object servletRequest = this.m.get((Object)"HTTP.REQUEST");
        if (servletRequest != null) {
            ((HttpServletRequest)servletRequest).setAttribute(ENDPOINT_ADDRESS_PROPERTY, (Object)baseUri.toString());
        }
    }

    public void setSecurityContext(SecurityContext sc) {
        this.checkContext();
        this.m.put(SecurityContext.class, (Object)sc);
    }

    private void checkNotPreMatch() {
        if (!this.preMatch) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setMethod(String method) throws IllegalStateException {
        this.checkNotPreMatch();
        super.setMethod(method);
    }
}

