/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util.crypto;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.CompressionUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.helpers.IOUtils;

public final class CryptoUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(CryptoUtils.class);

    private CryptoUtils() {
    }

    public static String encodeSecretKey(SecretKey key) throws SecurityException {
        return CryptoUtils.encodeBytes(key.getEncoded());
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey) throws SecurityException {
        KeyProperties props = new KeyProperties(publicKey.getAlgorithm());
        return CryptoUtils.encryptSecretKey(secretKey, publicKey, props);
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey, KeyProperties props) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.encryptBytes(secretKey.getEncoded(), publicKey, props);
        return CryptoUtils.encodeBytes(encryptedBytes);
    }

    public static byte[] generateSecureRandomBytes(int size) {
        SecureRandom sr = new SecureRandom();
        byte[] bytes = new byte[size];
        sr.nextBytes(bytes);
        return bytes;
    }

    public static RSAPublicKey getRSAPublicKey(String encodedModulus, String encodedPublicExponent) {
        try {
            return CryptoUtils.getRSAPublicKey(CryptoUtils.decodeSequence(encodedModulus), CryptoUtils.decodeSequence(encodedPublicExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPublicKey getRSAPublicKey(byte[] modulusBytes, byte[] publicExponentBytes) {
        try {
            return CryptoUtils.getRSAPublicKey(KeyFactory.getInstance("RSA"), modulusBytes, publicExponentBytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPublicKey getRSAPublicKey(KeyFactory factory, byte[] modulusBytes, byte[] publicExponentBytes) {
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger publicExponent = new BigInteger(1, publicExponentBytes);
        try {
            return (RSAPublicKey)factory.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(String encodedModulus, String encodedPrivateExponent) {
        try {
            return CryptoUtils.getRSAPrivateKey(CryptoUtils.decodeSequence(encodedModulus), CryptoUtils.decodeSequence(encodedPrivateExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(byte[] modulusBytes, byte[] privateExponentBytes) {
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger privateExponent = new BigInteger(1, privateExponentBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)factory.generatePrivate(new RSAPrivateKeySpec(modulus, privateExponent));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(String encodedModulus, String encodedPublicExponent, String encodedPrivateExponent, String encodedPrimeP, String encodedPrimeQ, String encodedPrimeExpP, String encodedPrimeExpQ, String encodedCrtCoefficient) {
        try {
            return CryptoUtils.getRSAPrivateKey(CryptoUtils.decodeSequence(encodedModulus), CryptoUtils.decodeSequence(encodedPublicExponent), CryptoUtils.decodeSequence(encodedPrivateExponent), CryptoUtils.decodeSequence(encodedPrimeP), CryptoUtils.decodeSequence(encodedPrimeQ), CryptoUtils.decodeSequence(encodedPrimeExpP), CryptoUtils.decodeSequence(encodedPrimeExpQ), CryptoUtils.decodeSequence(encodedCrtCoefficient));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(byte[] modulusBytes, byte[] publicExponentBytes, byte[] privateExponentBytes, byte[] primePBytes, byte[] primeQBytes, byte[] primeExpPBytes, byte[] primeExpQBytes, byte[] crtCoefficientBytes) {
        BigInteger modulus = new BigInteger(1, modulusBytes);
        BigInteger publicExponent = new BigInteger(1, publicExponentBytes);
        BigInteger privateExponent = new BigInteger(1, privateExponentBytes);
        BigInteger primeP = new BigInteger(1, primePBytes);
        BigInteger primeQ = new BigInteger(1, primeQBytes);
        BigInteger primeExpP = new BigInteger(1, primeExpPBytes);
        BigInteger primeExpQ = new BigInteger(1, primeExpQBytes);
        BigInteger crtCoefficient = new BigInteger(1, crtCoefficientBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)factory.generatePrivate(new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExpP, primeExpQ, crtCoefficient));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static ECPrivateKey getECPrivateKey(String curve, String encodedPrivateKey) {
        try {
            return CryptoUtils.getECPrivateKey(curve, CryptoUtils.decodeSequence(encodedPrivateKey));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static ECPrivateKey getECPrivateKey(String curve, byte[] privateKey) {
        try {
            ECParameterSpec params = CryptoUtils.getECParameterSpec(curve, true);
            ECPrivateKeySpec keySpec = new ECPrivateKeySpec(new BigInteger(1, privateKey), params);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return (ECPrivateKey)kf.generatePrivate(keySpec);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static ECParameterSpec getECParameterSpec(String curve, boolean isPrivate) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec kpgparams = new ECGenParameterSpec("sec" + curve.toLowerCase().replace("-", "") + "r1");
        kpg.initialize(kpgparams);
        KeyPair pair = kpg.generateKeyPair();
        return isPrivate ? ((ECPublicKey)pair.getPublic()).getParams() : ((ECPrivateKey)pair.getPrivate()).getParams();
    }

    public static ECPublicKey getECPublicKey(String curve, String encodedXPoint, String encodedYPoint) {
        try {
            return CryptoUtils.getECPublicKey(curve, CryptoUtils.decodeSequence(encodedXPoint), CryptoUtils.decodeSequence(encodedYPoint));
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static ECPublicKey getECPublicKey(String curve, byte[] xPoint, byte[] yPoint) {
        try {
            ECParameterSpec params = CryptoUtils.getECParameterSpec(curve, false);
            ECPoint ecPoint = new ECPoint(new BigInteger(1, xPoint), new BigInteger(1, yPoint));
            ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, params);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return (ECPublicKey)kf.generatePublic(keySpec);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static AlgorithmParameterSpec getContentEncryptionCipherSpec(int authTagLength, byte[] iv) {
        if (authTagLength > 0) {
            return CryptoUtils.getGCMParameterSpec(authTagLength, iv);
        }
        if (iv.length > 0) {
            return new IvParameterSpec(iv);
        }
        return null;
    }

    public static AlgorithmParameterSpec getGCMParameterSpec(int authTagLength, byte[] iv) {
        try {
            Class<?> c = ClassLoaderUtils.loadClass("javax.crypto.spec.GCMParameterSpec", CryptoUtils.class);
            Constructor<?> ctr = c.getConstructor(Integer.TYPE, byte[].class);
            return (AlgorithmParameterSpec)ctr.newInstance(authTagLength, iv);
        }
        catch (Throwable t) {
            return new IvParameterSpec(iv);
        }
    }

    public static byte[] signData(byte[] data, PrivateKey key, String signAlgo) {
        return CryptoUtils.signData(data, key, signAlgo, null, null);
    }

    public static byte[] signData(byte[] data, PrivateKey key, String signAlgo, SecureRandom random, AlgorithmParameterSpec params) {
        try {
            Signature s = CryptoUtils.getSignature(key, signAlgo, random, params);
            s.update(data);
            return s.sign();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static Signature getSignature(PrivateKey key, String signAlgo, SecureRandom random, AlgorithmParameterSpec params) {
        try {
            Signature s = Signature.getInstance(signAlgo);
            if (random == null) {
                s.initSign(key);
            } else {
                s.initSign(key, random);
            }
            if (params != null) {
                s.setParameter(params);
            }
            return s;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static boolean verifySignature(byte[] data, byte[] signature, PublicKey key, String signAlgo) {
        return CryptoUtils.verifySignature(data, signature, key, signAlgo, null);
    }

    public static boolean verifySignature(byte[] data, byte[] signature, PublicKey key, String signAlgo, AlgorithmParameterSpec params) {
        try {
            Signature s = Signature.getInstance(signAlgo);
            s.initVerify(key);
            if (params != null) {
                s.setParameter(params);
            }
            s.update(data);
            return s.verify(signature);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static SecretKey getSecretKey(String symEncAlgo) throws SecurityException {
        return CryptoUtils.getSecretKey(new KeyProperties(symEncAlgo));
    }

    public static SecretKey getSecretKey(String symEncAlgo, int keySize) throws SecurityException {
        return CryptoUtils.getSecretKey(new KeyProperties(symEncAlgo, keySize));
    }

    public static SecretKey getSecretKey(KeyProperties props) throws SecurityException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(props.getKeyAlgo());
            AlgorithmParameterSpec algoSpec = props.getAlgoSpec();
            SecureRandom random = props.getSecureRandom();
            if (algoSpec != null) {
                if (random != null) {
                    keyGen.init(algoSpec, random);
                } else {
                    keyGen.init(algoSpec);
                }
            } else {
                int keySize = props.getKeySize();
                if (keySize == -1) {
                    keySize = 128;
                }
                if (random != null) {
                    keyGen.init(keySize, random);
                } else {
                    keyGen.init(keySize);
                }
            }
            return keyGen.generateKey();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String decryptSequence(String encodedToken, String encodedSecretKey) throws SecurityException {
        return CryptoUtils.decryptSequence(encodedToken, encodedSecretKey, new KeyProperties("AES"));
    }

    public static String decryptSequence(String encodedData, String encodedSecretKey, KeyProperties props) throws SecurityException {
        SecretKey key = CryptoUtils.decodeSecretKey(encodedSecretKey, props.getKeyAlgo());
        return CryptoUtils.decryptSequence(encodedData, key, props);
    }

    public static String decryptSequence(String encodedData, Key secretKey) throws SecurityException {
        return CryptoUtils.decryptSequence(encodedData, secretKey, null);
    }

    public static String decryptSequence(String encodedData, Key secretKey, KeyProperties props) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.decodeSequence(encodedData);
        byte[] bytes = CryptoUtils.decryptBytes(encryptedBytes, secretKey, props);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String encryptSequence(String sequence, Key secretKey) throws SecurityException {
        return CryptoUtils.encryptSequence(sequence, secretKey, null);
    }

    public static String encryptSequence(String sequence, Key secretKey, KeyProperties keyProps) throws SecurityException {
        try {
            byte[] bytes = CryptoUtils.encryptBytes(sequence.getBytes("UTF-8"), secretKey, keyProps);
            return CryptoUtils.encodeBytes(bytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String encodeBytes(byte[] bytes) throws SecurityException {
        try {
            return Base64UrlUtility.encode(bytes);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey) throws SecurityException {
        return CryptoUtils.encryptBytes(bytes, secretKey, null);
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey, KeyProperties keyProps) throws SecurityException {
        return CryptoUtils.processBytes(bytes, secretKey, keyProps, 1);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey) throws SecurityException {
        return CryptoUtils.decryptBytes(bytes, secretKey, null);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey, KeyProperties keyProps) throws SecurityException {
        return CryptoUtils.processBytes(bytes, secretKey, keyProps, 2);
    }

    public static byte[] wrapSecretKey(byte[] keyBytes, String keyAlgo, Key wrapperKey, KeyProperties wrapperKeyProps) throws SecurityException {
        return CryptoUtils.wrapSecretKey(new SecretKeySpec(keyBytes, CryptoUtils.convertJCECipherToSecretKeyName(keyAlgo)), wrapperKey, wrapperKeyProps);
    }

    public static byte[] wrapSecretKey(Key secretKey, Key wrapperKey, KeyProperties keyProps) throws SecurityException {
        try {
            Cipher c = CryptoUtils.initCipher(wrapperKey, keyProps, 3);
            return c.wrap(secretKey);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static SecretKey unwrapSecretKey(byte[] wrappedBytes, String wrappedKeyAlgo, Key unwrapperKey, String unwrapperKeyAlgo) throws SecurityException {
        return CryptoUtils.unwrapSecretKey(wrappedBytes, wrappedKeyAlgo, unwrapperKey, new KeyProperties(unwrapperKeyAlgo));
    }

    public static SecretKey unwrapSecretKey(byte[] wrappedBytes, String wrappedKeyAlgo, Key unwrapperKey, KeyProperties keyProps) throws SecurityException {
        return (SecretKey)CryptoUtils.unwrapKey(wrappedBytes, wrappedKeyAlgo, unwrapperKey, keyProps, 3);
    }

    public static Key unwrapKey(byte[] wrappedBytes, String wrappedKeyAlgo, Key unwrapperKey, KeyProperties keyProps, int wrappedKeyType) throws SecurityException {
        try {
            Cipher c = CryptoUtils.initCipher(unwrapperKey, keyProps, 4);
            return c.unwrap(wrappedBytes, wrappedKeyAlgo, wrappedKeyType);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] processBytes(byte[] bytes, Key secretKey, KeyProperties keyProps, int mode) throws SecurityException {
        boolean compressionSupported;
        boolean bl = compressionSupported = keyProps != null && keyProps.isCompressionSupported();
        if (compressionSupported && mode == 1) {
            bytes = CompressionUtils.deflate(bytes, false);
        }
        try {
            int blockSize;
            Cipher c = CryptoUtils.initCipher(secretKey, keyProps, mode);
            byte[] result = new byte[]{};
            int n = blockSize = keyProps != null ? keyProps.getBlockSize() : -1;
            if (secretKey instanceof SecretKey && blockSize == -1) {
                result = c.doFinal(bytes);
            } else {
                if (blockSize == -1) {
                    blockSize = secretKey instanceof PublicKey ? 117 : 128;
                }
                boolean updateRequired = keyProps != null && keyProps.getAdditionalData() != null;
                int offset = 0;
                while (offset + blockSize < bytes.length) {
                    byte[] next = !updateRequired ? c.doFinal(bytes, offset, blockSize) : c.update(bytes, offset, blockSize);
                    result = CryptoUtils.addToResult(result, next);
                    offset += blockSize;
                }
                result = offset < bytes.length ? CryptoUtils.addToResult(result, c.doFinal(bytes, offset, bytes.length - offset)) : CryptoUtils.addToResult(result, c.doFinal());
            }
            if (compressionSupported && mode == 2) {
                result = IOUtils.readBytesFromStream(CompressionUtils.inflate(result, false));
            }
            return result;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static Cipher initCipher(Key secretKey, KeyProperties keyProps, int mode) throws SecurityException {
        try {
            String algorithm = keyProps != null && keyProps.getKeyAlgo() != null ? keyProps.getKeyAlgo() : secretKey.getAlgorithm();
            Cipher c = Cipher.getInstance(algorithm);
            if (keyProps == null || keyProps.getAlgoSpec() == null && keyProps.getSecureRandom() == null) {
                c.init(mode, secretKey);
            } else {
                AlgorithmParameterSpec algoSpec = keyProps.getAlgoSpec();
                SecureRandom random = keyProps.getSecureRandom();
                if (algoSpec == null) {
                    c.init(mode, secretKey, random);
                } else if (random == null) {
                    c.init(mode, secretKey, algoSpec);
                } else {
                    c.init(mode, secretKey, algoSpec, random);
                }
            }
            if (keyProps != null && keyProps.getAdditionalData() != null) {
                try {
                    Method m = Cipher.class.getMethod("updateAAD", byte[].class);
                    m.invoke((Object)c, new Object[]{keyProps.getAdditionalData()});
                }
                catch (NoSuchMethodException ex) {
                    LOG.fine(ex.getMessage());
                }
            }
            return c;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] addToResult(byte[] prefix, byte[] suffix) {
        if (suffix == null || suffix.length == 0) {
            return prefix;
        }
        if (prefix.length == 0) {
            return suffix;
        }
        byte[] result = new byte[prefix.length + suffix.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(suffix, 0, result, prefix.length, suffix.length);
        return result;
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey) throws SecurityException {
        return CryptoUtils.decodeSecretKey(encodedSecretKey, "AES");
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey, String secretKeyAlgo) throws SecurityException {
        byte[] secretKeyBytes = CryptoUtils.decodeSequence(encodedSecretKey);
        return CryptoUtils.createSecretKeySpec(secretKeyBytes, secretKeyAlgo);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, PrivateKey privateKey) {
        return CryptoUtils.decryptSecretKey(encodedEncryptedSecretKey, "AES", privateKey);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, String secretKeyAlgo, PrivateKey privateKey) throws SecurityException {
        KeyProperties props = new KeyProperties(privateKey.getAlgorithm());
        return CryptoUtils.decryptSecretKey(encodedEncryptedSecretKey, secretKeyAlgo, props, privateKey);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, String secretKeyAlgo, KeyProperties props, PrivateKey privateKey) throws SecurityException {
        byte[] encryptedBytes = CryptoUtils.decodeSequence(encodedEncryptedSecretKey);
        byte[] descryptedBytes = CryptoUtils.decryptBytes(encryptedBytes, privateKey, props);
        return CryptoUtils.createSecretKeySpec(descryptedBytes, secretKeyAlgo);
    }

    public static SecretKey createSecretKeySpec(String encodedBytes, String algo) {
        return new SecretKeySpec(CryptoUtils.decodeSequence(encodedBytes), algo);
    }

    public static SecretKey createSecretKeySpec(byte[] bytes, String algo) {
        return new SecretKeySpec(bytes, CryptoUtils.convertJCECipherToSecretKeyName(algo));
    }

    public static byte[] decodeSequence(String encodedSequence) throws SecurityException {
        try {
            return Base64UrlUtility.decode(encodedSequence);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static String convertJCECipherToSecretKeyName(String jceCipherName) {
        if (jceCipherName != null) {
            if (jceCipherName.startsWith("AES")) {
                return "AES";
            }
            if (jceCipherName.startsWith("DESede")) {
                return "DESede";
            }
            if (jceCipherName.startsWith("SEED")) {
                return "SEED";
            }
            if (jceCipherName.startsWith("Camellia")) {
                return "Camellia";
            }
        }
        return null;
    }

    public static Certificate loadCertificate(InputStream storeLocation, char[] storePassword, String alias, String storeType) {
        KeyStore keyStore = CryptoUtils.loadKeyStore(storeLocation, storePassword, storeType);
        return CryptoUtils.loadCertificate(keyStore, alias);
    }

    public static Certificate loadCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PublicKey loadPublicKey(InputStream storeLocation, char[] storePassword, String alias, String storeType) {
        return CryptoUtils.loadCertificate(storeLocation, storePassword, alias, storeType).getPublicKey();
    }

    public static PublicKey loadPublicKey(KeyStore keyStore, String alias) {
        return CryptoUtils.loadCertificate(keyStore, alias).getPublicKey();
    }

    public static KeyStore loadKeyStore(InputStream storeLocation, char[] storePassword, String type) {
        try {
            KeyStore ks = KeyStore.getInstance(type == null ? KeyStore.getDefaultType() : type);
            ks.load(storeLocation, storePassword);
            return ks;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PrivateKey loadPrivateKey(InputStream storeLocation, char[] storePassword, char[] keyPassword, String alias, String storeType) {
        KeyStore keyStore = CryptoUtils.loadKeyStore(storeLocation, storePassword, storeType);
        return CryptoUtils.loadPrivateKey(keyStore, keyPassword, alias);
    }

    public static PrivateKey loadPrivateKey(KeyStore keyStore, char[] keyPassword, String alias) {
        try {
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword));
            return pkEntry.getPrivateKey();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }
}

