/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentDisposition {
    private static final String CD_HEADER_PARAMS_EXPRESSION = "(([\\w]+( )?=( )?\"[^\"]+\")|([\\w]+( )?=( )?[^;]+))";
    private static final Pattern CD_HEADER_PARAMS_PATTERN = Pattern.compile("(([\\w]+( )?=( )?\"[^\"]+\")|([\\w]+( )?=( )?[^;]+))");
    private String value;
    private String type;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public ContentDisposition(String value) {
        this.value = value;
        String tempValue = value;
        int index = tempValue.indexOf(59);
        if (index > 0 && tempValue.indexOf(61) >= index) {
            this.type = tempValue.substring(0, index).trim();
            tempValue = tempValue.substring(index + 1);
        }
        Matcher m = CD_HEADER_PARAMS_PATTERN.matcher(tempValue);
        while (m.find()) {
            String[] pair = m.group().trim().split("=");
            this.params.put(pair[0].trim(), pair.length == 2 ? pair[1].trim().replace("\"", "") : "");
        }
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public String toString() {
        return this.value;
    }
}

