/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Systems {
    private static final transient Logger LOG = LoggerFactory.getLogger(Systems.class);

    public static String getEnvVarOrSystemProperty(String envVarName, String systemProperty, String defaultValue) {
        String answer = null;
        try {
            answer = System.getenv(envVarName);
        }
        catch (Exception e) {
            LOG.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (Strings.isNullOrBlank(answer)) {
            answer = System.getProperty(systemProperty, defaultValue);
        }
        if (Strings.isNotBlank(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static String getEnvVarOrSystemProperty(String envVarName, String defaultValue) {
        return Systems.getEnvVarOrSystemProperty(envVarName, envVarName, defaultValue);
    }

    public static Number getEnvVarOrSystemProperty(String name, Number defaultValue) {
        String result = Systems.getEnvVarOrSystemProperty(name, defaultValue.toString());
        return Integer.parseInt(result);
    }

    public static Boolean getEnvVarOrSystemProperty(String name, Boolean defaultValue) {
        String result = Systems.getEnvVarOrSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String envVar = null;
        try {
            envVar = System.getenv(envVarName);
        }
        catch (Exception e) {
            LOG.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (Strings.isNotBlank(envVar)) {
            return envVar;
        }
        return defaultValue;
    }

    public static String getServiceHostAndPort(String serviceNameEnvVar, String defaultServiceName, String defaultHost, String defaultPort) {
        String serviceName = Systems.getEnvVarOrSystemProperty(serviceNameEnvVar, serviceNameEnvVar, defaultServiceName);
        String serviceEnvVarPrefix = Systems.getServiceEnvVarPrefix(serviceName);
        String hostEnvVar = serviceEnvVarPrefix + "_HOST";
        String portEnvVar = serviceEnvVarPrefix + "_PORT";
        String host = Systems.getEnvVarOrSystemProperty(hostEnvVar, hostEnvVar, defaultHost);
        String port = Systems.getEnvVarOrSystemProperty(portEnvVar, portEnvVar, defaultPort);
        String answer = host + ":" + port;
        LOG.info("Connecting to service " + serviceName + " on " + answer + " from $" + hostEnvVar + " and $" + portEnvVar + ". To use a different service address please specify $" + serviceNameEnvVar + "=someServiceName where 'someServiceName' is the id of a service in Kubernetes");
        return answer;
    }

    public static String getServiceHostAndPort(String serviceName, String defaultHost, String defaultPort) {
        String serviceEnvVarPrefix = Systems.getServiceEnvVarPrefix(serviceName);
        String hostEnvVar = serviceEnvVarPrefix + "_HOST";
        String portEnvVar = serviceEnvVarPrefix + "_PORT";
        String host = Systems.getEnvVarOrSystemProperty(hostEnvVar, hostEnvVar, defaultHost);
        String port = Systems.getEnvVarOrSystemProperty(portEnvVar, portEnvVar, defaultPort);
        String answer = host + ":" + port;
        LOG.info("Connecting to service " + serviceName + " on " + answer + " from $" + hostEnvVar + " and $" + portEnvVar);
        return answer;
    }

    protected static String getServiceEnvVarPrefix(String serviceName) {
        return serviceName.toUpperCase() + "_SERVICE";
    }
}

