/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.PodSchema;
import java.util.Map;

public class AppPodSummaryDTO {
    private final String id;
    private final String namespace;
    private final PodStatus status;
    private final Map<String, String> labels;

    public AppPodSummaryDTO(PodSchema pod) {
        this.id = pod.getId();
        this.namespace = pod.getNamespace();
        this.status = KubernetesHelper.getPodStatus(pod);
        this.labels = pod.getLabels();
    }

    public String toString() {
        return "AppPodSummaryDTO{id='" + this.id + '\'' + ", namespace='" + this.namespace + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }

    public String getId() {
        return this.id;
    }

    public PodStatus getStatus() {
        return this.status;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }
}

