/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.k8s;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ManifestContainer;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.Port;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class K8sUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private Kubernetes kubernetes = new KubernetesFactory().createKubernetes();
    private TransportService transportService;
    private NetworkService networkService;
    private final String selector;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public K8sUnicastHostsProvider(Settings settings, TransportService transportService, NetworkService networkService) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", settings.getAsTime("cloud.k8s.refresh_interval", TimeValue.timeValueSeconds((long)0L)));
        this.selector = this.componentSettings.get("selector", settings.get("cloud.k8s.selector"));
        this.checkProperty("selector", this.selector);
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list", new Object[0]);
                }
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API", new Object[0]);
        this.cachedDiscoNodes = Lists.newArrayList();
        String ipAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddress(null);
            if (inetAddress != null) {
                ipAddress = inetAddress.getHostAddress();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Map podMap = KubernetesHelper.getPodMap((Kubernetes)this.kubernetes, (String)this.selector);
            Collection pods = podMap.values();
            if (pods == null) {
                this.logger.trace("no pod found for selector [{}].", new Object[]{this.selector});
                return this.cachedDiscoNodes;
            }
            for (PodSchema pod : pods) {
                String status = pod.getCurrentState().getStatus();
                this.logger.trace("k8s instance {} with status {} found.", new Object[]{pod.getId(), status});
                if (!status.equals("Running")) {
                    this.logger.trace("k8s instance {} is not running - ignoring.", new Object[]{pod.getId()});
                    continue;
                }
                try {
                    String podIp = pod.getCurrentState().getPodIP();
                    if (podIp.equals(ipAddress)) {
                        this.logger.trace("current node found. Ignoring {} - {}", new Object[]{pod.getId(), podIp});
                        continue;
                    }
                    List containers = KubernetesHelper.getContainers((PodSchema)pod);
                    for (ManifestContainer container : containers) {
                        this.logger.trace("pod " + pod.getId() + " container: " + container.getName() + " image: " + container.getImage(), new Object[0]);
                        List ports = container.getPorts();
                        for (Port port : ports) {
                            Integer containerPort = port.getContainerPort();
                            if (containerPort != 9300) continue;
                            String address = podIp.concat(":").concat(containerPort.toString());
                            TransportAddress[] addresses = this.transportService.addressesFromString(address);
                            this.logger.trace("adding {}, address {}, transport_address {}, status {}", new Object[]{pod.getId(), podIp, addresses[0], status});
                            this.cachedDiscoNodes.add(new DiscoveryNode("#cloud-" + pod.getId() + "-" + 0, addresses[0], Version.CURRENT));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("failed to add {}", (Throwable)e, new Object[]{pod.getId()});
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery {} : {}", new Object[]{e.getClass().getName(), e.getMessage()});
            this.logger.trace("Exception caught during discovery", e, new Object[0]);
        }
        this.logger.debug("{} node(s) added", new Object[]{this.cachedDiscoNodes.size()});
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{this.cachedDiscoNodes});
        return this.cachedDiscoNodes;
    }

    private void checkProperty(String name, String value) {
        if (!Strings.hasText((String)value)) {
            this.logger.warn("cloud.k8s.{} is not set.", new Object[]{name});
        }
    }

    public static final class Fields {
        public static final String REFRESH = "refresh_interval";
        public static final String VERSION = "Elasticsearch/K8sCloud/1.0";
        public static final String SELECTOR = "selector";
    }

    static final class Status {
        private static final String RUNNING = "Running";

        Status() {
        }
    }
}

