/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaxb.dynamic;

import io.fabric8.jaxb.dynamic.CompileResults;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class DynamicXJC {
    private static final Logger LOG = LogUtils.getL7dLogger(DynamicXJC.class);
    private String[] schemaCompilerOptions;
    private String tmpdir = SystemPropertyAction.getProperty((String)"java.io.tmpdir");
    private final ClassLoader classLoader;
    private Map<String, Object> jaxbContextProperties;
    private List<String> schemaUrls = new ArrayList<String>();

    public DynamicXJC(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CompileResults compileSchemas() {
        JAXBContext context;
        URL[] urls;
        JAXBUtils.SchemaCompiler compiler = this.createSchemaCompiler();
        String stem = this.toString() + "-" + System.currentTimeMillis();
        File src = new File(this.tmpdir, stem + "-src");
        if (!src.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + src.getPath());
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String rawUrl : this.getSchemaUrls()) {
            String schemaUrl = this.resolveUrl(rawUrl);
            InnerErrorListener listener = new InnerErrorListener(schemaUrl);
            Object elForRun = ReflectionInvokationHandler.createProxyWrapper((Object)listener, (Class)JAXBUtils.getParamClass((JAXBUtils.SchemaCompiler)compiler, (String)"setErrorListener"));
            compiler.setErrorListener(elForRun);
            compiler.parseSchema(new InputSource(schemaUrl));
            JAXBUtils.S2JJAXBModel intermediateModel = compiler.bind();
            listener.throwException();
            JAXBUtils.JCodeModel codeModel = intermediateModel.generateCode(null, elForRun);
            Iterator packages = codeModel.packages();
            while (packages.hasNext()) {
                JAXBUtils.JPackage jpackage = (JAXBUtils.JPackage)packages.next();
                if (!this.isValidPackage(jpackage)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(':');
                }
                sb.append(jpackage.name());
            }
            JAXBUtils.logGeneratedClassNames((Logger)LOG, (JAXBUtils.JCodeModel)codeModel);
            try {
                Object writer = JAXBUtils.createFileCodeWriter((File)src);
                codeModel.build(writer);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to write generated Java files for schemas: " + e.getMessage(), e);
            }
        }
        String packageList = sb.toString();
        File classes = new File(this.tmpdir, stem + "-classes");
        if (!classes.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + classes.getPath());
        }
        StringBuilder classPath = new StringBuilder();
        try {
            DynamicXJC.setupClasspath(classPath, this.classLoader);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List srcFiles = FileUtils.getFilesRecurse((File)src, (String)".+\\.java$");
        if (!this.compileJavaSrc(classPath.toString(), srcFiles, classes.toString())) {
            LOG.log(Level.SEVERE, new Message("COULD_NOT_COMPILE_SRC", LOG, new Object[]{this.getSchemaUrls().toString()}).toString());
        }
        FileUtils.removeDir((File)src);
        try {
            urls = new URL[]{classes.toURI().toURL()};
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Internal error; a directory returns a malformed URL: " + mue.getMessage(), mue);
        }
        ClassLoader cl = ClassLoaderUtils.getURLClassLoader((URL[])urls, (ClassLoader)this.classLoader);
        Map<String, Object> contextProperties = this.jaxbContextProperties;
        if (contextProperties == null) {
            contextProperties = Collections.emptyMap();
        }
        try {
            context = StringUtils.isEmpty((String)packageList) ? JAXBContext.newInstance((Class[])new Class[0], contextProperties) : JAXBContext.newInstance((String)packageList, (ClassLoader)cl, contextProperties);
        }
        catch (JAXBException jbe) {
            throw new IllegalStateException("Unable to create JAXBContext for generated packages: " + jbe.getMessage(), jbe);
        }
        classes.deleteOnExit();
        return new CompileResults(cl, context);
    }

    public void addSchemaUrl(String url) {
        this.getSchemaUrls().add(url);
    }

    public List<String> getSchemaUrls() {
        return this.schemaUrls;
    }

    public void setSchemaUrls(List<String> schemaUrls) {
        this.schemaUrls = schemaUrls;
    }

    public Map<String, Object> getJaxbContextProperties() {
        return this.jaxbContextProperties;
    }

    public void setJaxbContextProperties(Map<String, Object> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public String[] getSchemaCompilerOptions() {
        return this.schemaCompilerOptions;
    }

    public void setSchemaCompilerOptions(String[] schemaCompilerOptions) {
        this.schemaCompilerOptions = schemaCompilerOptions;
    }

    protected JAXBUtils.SchemaCompiler createSchemaCompiler() {
        JAXBUtils.SchemaCompiler compiler = JAXBUtils.createSchemaCompilerWithDefaultAllocator(new HashSet());
        if (this.schemaCompilerOptions != null && this.schemaCompilerOptions.length > 0) {
            compiler.getOptions().parseArguments(this.schemaCompilerOptions);
        }
        return compiler;
    }

    protected String resolveUrl(String rawUrl) {
        String classpathPrefix = "classpath:";
        if (rawUrl.startsWith(classpathPrefix)) {
            String remaining = rawUrl.substring(classpathPrefix.length());
            try {
                URL resource = ClassLoaderUtils.getResource((String)remaining, this.getClass());
                if (resource != null) {
                    return resource.toString();
                }
            }
            catch (Throwable e) {
                LOG.fine("Ignored error trying to resolve '" + remaining + "' on the classpath: " + e);
            }
        }
        return rawUrl;
    }

    private boolean isValidPackage(JAXBUtils.JPackage jpackage) {
        if (jpackage == null) {
            return false;
        }
        String name = jpackage.name();
        if ("org.w3._2001.xmlschema".equals(name) || "java.lang".equals(name) || "java.io".equals(name) || "generated".equals(name)) {
            return false;
        }
        Iterator i = jpackage.classes();
        while (i.hasNext()) {
            JAXBUtils.JDefinedClass current = (JAXBUtils.JDefinedClass)i.next();
            if (!"ObjectFactory".equals(current.name())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addClasspathFromManifest(StringBuilder classPath, File file) throws URISyntaxException, IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Attributes attr = null;
            if (jar.getManifest() != null) {
                attr = jar.getManifest().getMainAttributes();
            }
            if (attr != null) {
                String cp = attr.getValue("Class-Path");
                while (cp != null) {
                    URI uri;
                    File f2;
                    String fileName = cp;
                    int idx = fileName.indexOf(32);
                    if (idx != -1) {
                        fileName = fileName.substring(0, idx);
                        cp = cp.substring(idx + 1).trim();
                    } else {
                        cp = null;
                    }
                    if (!(f2 = (uri = new URI(fileName)).isAbsolute() ? new File(uri) : new File(file, fileName)).exists()) continue;
                    classPath.append(f2.getAbsolutePath());
                    classPath.append(File.pathSeparator);
                }
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    static void setupClasspath(StringBuilder classPath, ClassLoader classLoader) throws URISyntaxException, IOException {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ClassLoader tcl = classLoader;
        do {
            if (tcl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)tcl).getURLs();
                if (urls == null) {
                    urls = new URL[]{};
                }
                for (URL url : urls) {
                    if (!url.getProtocol().startsWith("file")) continue;
                    File file = null;
                    try {
                        if (url.getPath() == null) continue;
                        file = new File(URLDecoder.decode(url.getPath(), "utf-8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                    if (null == file || !file.exists()) continue;
                    classPath.append(file.getAbsolutePath()).append(System.getProperty("path.separator"));
                    if (!file.getName().endsWith(".jar")) continue;
                    DynamicXJC.addClasspathFromManifest(classPath, file);
                }
                continue;
            }
            if (!tcl.getClass().getName().contains("weblogic")) continue;
            try {
                Method method = tcl.getClass().getMethod("getClassPath", new Class[0]);
                Object weblogicClassPath = method.invoke((Object)tcl, new Object[0]);
                classPath.append(weblogicClassPath).append(File.pathSeparator);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "unsuccessfully tried getClassPath method", e);
            }
        } while (null != (tcl = tcl.getParent()) && !tcl.equals(scl.getParent()));
    }

    protected boolean compileJavaSrc(String classPath, List<File> srcList, String dest) {
        Compiler javaCompiler = new Compiler();
        javaCompiler.setClassPath(classPath);
        javaCompiler.setOutputDir(dest);
        javaCompiler.setTarget("1.6");
        return javaCompiler.compileFiles(srcList);
    }

    class InnerErrorListener {
        private String url;
        private StringBuilder errors = new StringBuilder();
        private Exception ex;

        InnerErrorListener(String url) {
            this.url = url;
        }

        public void throwException() {
            if (this.errors.length() > 0) {
                throw new RuntimeException(this.errors.toString(), this.ex);
            }
        }

        public void error(SAXParseException arg0) {
            if (this.ex == null) {
                this.ex = arg0;
            }
            if (this.errors.length() == 0) {
                this.errors.append("Error compiling schema from WSDL at {").append(this.url).append("}: \n");
            } else {
                this.errors.append("\n");
            }
            if (arg0.getLineNumber() > 0) {
                this.errors.append(arg0.getLocalizedMessage() + "\n" + " at line " + arg0.getLineNumber() + " column " + arg0.getColumnNumber() + " of schema " + arg0.getSystemId() + "\n");
            } else {
                this.errors.append(arg0.getMessage());
                this.errors.append("\n");
            }
        }

        public void fatalError(SAXParseException arg0) {
            throw new RuntimeException("Fatal error compiling schema from WSDL at {" + this.url + "}: " + arg0.getMessage(), arg0);
        }

        public void info(SAXParseException arg0) {
        }

        public void warning(SAXParseException arg0) {
        }
    }
}

