/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.server.mock;

import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockWebServer;
import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.DockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.server.mock.MockDispatcher;
import io.fabric8.docker.server.mock.MockSSLContextFactory;
import io.fabric8.docker.server.mock.MockServerExpectation;
import io.fabric8.docker.server.mock.MockServerExpectationImpl;
import io.fabric8.docker.server.mock.ServerRequest;
import io.fabric8.docker.server.mock.ServerResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class DockerMockServer {
    private final boolean useHttps;
    private MockWebServer server = new MockWebServer();
    private Map<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();

    public DockerMockServer() {
        this(true);
    }

    public DockerMockServer(boolean useHttps) {
        this.useHttps = useHttps;
    }

    public void init() {
        try {
            if (this.useHttps) {
                this.server.useHttps(MockSSLContextFactory.create().getSocketFactory(), false);
            }
            this.server.setDispatcher((Dispatcher)new MockDispatcher(this.responses));
            this.server.play();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public DockerClient createClient() {
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.server.getUrl("/").toString())).withTrustCerts(true)).build();
        return new DefaultDockerClient((Config)config);
    }

    public void destroy() throws IOException {
        this.server.shutdown();
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public MockServerExpectation expect() {
        return new MockServerExpectationImpl(this.responses);
    }
}

