/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.server.mock;

import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.RecordedRequest;
import io.fabric8.docker.server.mock.ServerRequest;
import io.fabric8.docker.server.mock.ServerResponse;
import java.util.Map;
import java.util.Queue;

public class MockDispatcher
extends Dispatcher {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.responses = responses;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String method = request.getMethod();
        String path = request.getPath();
        ServerRequest key = new ServerRequest(method, path);
        ServerRequest keyForAnyMethod = new ServerRequest(path);
        if (this.responses.containsKey(key)) {
            Queue<ServerResponse> queue = this.responses.get(key);
            return this.handleResponse(queue.peek(), queue);
        }
        if (this.responses.containsKey(keyForAnyMethod)) {
            Queue<ServerResponse> queue = this.responses.get(keyForAnyMethod);
            return this.handleResponse(queue.peek(), queue);
        }
        return new MockResponse().setResponseCode(404);
    }

    private MockResponse handleResponse(ServerResponse response, Queue<ServerResponse> queue) {
        if (response == null) {
            return new MockResponse().setResponseCode(404);
        }
        if (response.isToBeRemoved()) {
            queue.remove();
        }
        MockResponse mockResponse = new MockResponse();
        mockResponse.setBody(response.getBody());
        mockResponse.setResponseCode(response.getCode());
        return mockResponse;
    }
}

