/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.docker.server.mock.MockServerExpectation;
import io.fabric8.docker.server.mock.Pathable;
import io.fabric8.docker.server.mock.Returnable;
import io.fabric8.docker.server.mock.ServerRequest;
import io.fabric8.docker.server.mock.ServerResponse;
import io.fabric8.docker.server.mock.Timeable;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;

public class MockServerExpectationImpl
implements MockServerExpectation {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String method;
    private final String path;
    private final int statusCode;
    private final String body;
    private final int times;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;

    public MockServerExpectationImpl(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this("", null, 200, null, 1, responses);
    }

    public MockServerExpectationImpl(String method, String path, int statusCode, String body, int times, Map<ServerRequest, Queue<ServerResponse>> responses) {
        this.method = method;
        this.path = path;
        this.statusCode = statusCode;
        this.body = body;
        this.times = times;
        this.responses = responses;
    }

    @Override
    public Pathable<Returnable<Timeable>> any() {
        return new MockServerExpectationImpl("", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<Returnable<Timeable>> post() {
        return new MockServerExpectationImpl("post", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<Returnable<Timeable>> get() {
        return new MockServerExpectationImpl("get", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<Returnable<Timeable>> put() {
        return new MockServerExpectationImpl("put", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Pathable<Returnable<Timeable>> delete() {
        return new MockServerExpectationImpl("delete", this.path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Returnable<Timeable> withPath(String path) {
        return new MockServerExpectationImpl(this.method, path, this.statusCode, this.body, this.times, this.responses);
    }

    @Override
    public Timeable andReturn(int statusCode, Object content) {
        if (content instanceof String) {
            return new MockServerExpectationImpl(this.method, this.path, statusCode, (String)content, this.times, this.responses);
        }
        try {
            return new MockServerExpectationImpl(this.method, this.path, statusCode, MAPPER.writeValueAsString(content), this.times, this.responses);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void always() {
        this.enqueue(new ServerRequest(this.method, this.path), new ServerResponse(this.statusCode, this.body, false));
    }

    @Override
    public void once() {
        this.enqueue(new ServerRequest(this.method, this.path), new ServerResponse(this.statusCode, this.body, true));
    }

    @Override
    public void times(int times) {
        for (int i = 0; i < times; ++i) {
            this.once();
        }
    }

    private void enqueue(ServerRequest req, ServerResponse resp) {
        Queue<ServerResponse> queuedResponses = this.responses.get(req);
        if (queuedResponses == null) {
            queuedResponses = new ArrayDeque<ServerResponse>();
            this.responses.put(req, queuedResponses);
        }
        queuedResponses.add(resp);
    }
}

