/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.IndexInfo;
import io.fabric8.docker.api.model.NetIPNet;
import io.fabric8.docker.api.model.NetIPNetBuilder;
import io.fabric8.docker.api.model.NetIPNetFluentImpl;
import io.fabric8.docker.api.model.ServiceConfig;
import io.fabric8.docker.api.model.ServiceConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceConfigFluentImpl<A extends ServiceConfigFluent<A>>
extends BaseFluent<A>
implements ServiceConfigFluent<A> {
    private Map<String, IndexInfo> IndexConfigs = new LinkedHashMap<String, IndexInfo>();
    private List<NetIPNetBuilder> InsecureRegistryCIDRs = new ArrayList<NetIPNetBuilder>();
    private List<String> Mirrors = new ArrayList<String>();

    public ServiceConfigFluentImpl() {
    }

    public ServiceConfigFluentImpl(ServiceConfig instance) {
        this.withIndexConfigs(instance.getIndexConfigs());
        this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        this.withMirrors(instance.getMirrors());
    }

    @Override
    public A addToIndexConfigs(String key, IndexInfo value) {
        if (key != null && value != null) {
            this.IndexConfigs.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToIndexConfigs(Map<String, IndexInfo> map) {
        if (map != null) {
            this.IndexConfigs.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromIndexConfigs(String key) {
        if (key != null) {
            this.IndexConfigs.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromIndexConfigs(Map<String, IndexInfo> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.IndexConfigs.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, IndexInfo> getIndexConfigs() {
        return this.IndexConfigs;
    }

    @Override
    public A withIndexConfigs(Map<String, IndexInfo> IndexConfigs) {
        this.IndexConfigs.clear();
        if (IndexConfigs != null) {
            this.IndexConfigs.putAll(IndexConfigs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIndexConfigs() {
        return this.IndexConfigs != null;
    }

    @Override
    public A addToInsecureRegistryCIDRs(int index, NetIPNet item) {
        NetIPNetBuilder builder = new NetIPNetBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.InsecureRegistryCIDRs.add(index >= 0 ? index : this.InsecureRegistryCIDRs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInsecureRegistryCIDRs(int index, NetIPNet item) {
        NetIPNetBuilder builder = new NetIPNetBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.InsecureRegistryCIDRs.size()) {
            this.InsecureRegistryCIDRs.add(builder);
        } else {
            this.InsecureRegistryCIDRs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInsecureRegistryCIDRs(NetIPNet ... items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.add(builder);
            this.InsecureRegistryCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInsecureRegistryCIDRs(Collection<NetIPNet> items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.add(builder);
            this.InsecureRegistryCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInsecureRegistryCIDRs(NetIPNet ... items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.remove(builder);
            this.InsecureRegistryCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInsecureRegistryCIDRs(Collection<NetIPNet> items) {
        for (NetIPNet item : items) {
            NetIPNetBuilder builder = new NetIPNetBuilder(item);
            this._visitables.remove(builder);
            this.InsecureRegistryCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetIPNet> getInsecureRegistryCIDRs() {
        return ServiceConfigFluentImpl.build(this.InsecureRegistryCIDRs);
    }

    @Override
    public List<NetIPNet> buildInsecureRegistryCIDRs() {
        return ServiceConfigFluentImpl.build(this.InsecureRegistryCIDRs);
    }

    @Override
    public NetIPNet buildInsecureRegistryCIDR(int index) {
        return this.InsecureRegistryCIDRs.get(index).build();
    }

    @Override
    public NetIPNet buildFirstInsecureRegistryCIDR() {
        return this.InsecureRegistryCIDRs.get(0).build();
    }

    @Override
    public NetIPNet buildLastInsecureRegistryCIDR() {
        return this.InsecureRegistryCIDRs.get(this.InsecureRegistryCIDRs.size() - 1).build();
    }

    @Override
    public NetIPNet buildMatchingInsecureRegistryCIDR(Predicate<NetIPNetBuilder> predicate) {
        for (NetIPNetBuilder item : this.InsecureRegistryCIDRs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withInsecureRegistryCIDRs(List<NetIPNet> InsecureRegistryCIDRs) {
        this._visitables.removeAll(this.InsecureRegistryCIDRs);
        this.InsecureRegistryCIDRs.clear();
        if (InsecureRegistryCIDRs != null) {
            for (NetIPNet item : InsecureRegistryCIDRs) {
                this.addToInsecureRegistryCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withInsecureRegistryCIDRs(NetIPNet ... InsecureRegistryCIDRs) {
        this.InsecureRegistryCIDRs.clear();
        if (InsecureRegistryCIDRs != null) {
            for (NetIPNet item : InsecureRegistryCIDRs) {
                this.addToInsecureRegistryCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInsecureRegistryCIDRs() {
        return this.InsecureRegistryCIDRs != null && !this.InsecureRegistryCIDRs.isEmpty();
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDR() {
        return new InsecureRegistryCIDRsNestedImpl();
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDRLike(NetIPNet item) {
        return new InsecureRegistryCIDRsNestedImpl(-1, item);
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> setNewInsecureRegistryCIDRLike(int index, NetIPNet item) {
        return new InsecureRegistryCIDRsNestedImpl(index, item);
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editInsecureRegistryCIDR(int index) {
        if (this.InsecureRegistryCIDRs.size() <= index) {
            throw new RuntimeException("Can't edit InsecureRegistryCIDRs. Index exceeds size.");
        }
        return this.setNewInsecureRegistryCIDRLike(index, this.buildInsecureRegistryCIDR(index));
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editFirstInsecureRegistryCIDR() {
        if (this.InsecureRegistryCIDRs.size() == 0) {
            throw new RuntimeException("Can't edit first InsecureRegistryCIDRs. The list is empty.");
        }
        return this.setNewInsecureRegistryCIDRLike(0, this.buildInsecureRegistryCIDR(0));
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editLastInsecureRegistryCIDR() {
        int index = this.InsecureRegistryCIDRs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last InsecureRegistryCIDRs. The list is empty.");
        }
        return this.setNewInsecureRegistryCIDRLike(index, this.buildInsecureRegistryCIDR(index));
    }

    @Override
    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> editMatchingInsecureRegistryCIDR(Predicate<NetIPNetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.InsecureRegistryCIDRs.size(); ++i) {
            if (!predicate.apply(this.InsecureRegistryCIDRs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching InsecureRegistryCIDRs. No match found.");
        }
        return this.setNewInsecureRegistryCIDRLike(index, this.buildInsecureRegistryCIDR(index));
    }

    @Override
    public A addNewInsecureRegistryCIDR(String ip, String mask) {
        return this.addToInsecureRegistryCIDRs(new NetIPNet(ip, mask));
    }

    @Override
    public A addNewInsecureRegistryCIDR(String s) {
        return this.addToInsecureRegistryCIDRs(new NetIPNet(s));
    }

    @Override
    public A addToMirrors(int index, String item) {
        this.Mirrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMirrors(int index, String item) {
        this.Mirrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMirrors(Collection<String> items) {
        for (String item : items) {
            this.Mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(String ... items) {
        for (String item : items) {
            this.Mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMirrors(Collection<String> items) {
        for (String item : items) {
            this.Mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMirrors() {
        return this.Mirrors;
    }

    @Override
    public String getMirror(int index) {
        return this.Mirrors.get(index);
    }

    @Override
    public String getFirstMirror() {
        return this.Mirrors.get(0);
    }

    @Override
    public String getLastMirror() {
        return this.Mirrors.get(this.Mirrors.size() - 1);
    }

    @Override
    public String getMatchingMirror(Predicate<String> predicate) {
        for (String item : this.Mirrors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withMirrors(List<String> Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMirrors(String ... Mirrors) {
        this.Mirrors.clear();
        if (Mirrors != null) {
            for (String item : Mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirrors() {
        return this.Mirrors != null && !this.Mirrors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceConfigFluentImpl that = (ServiceConfigFluentImpl)o;
        if (this.IndexConfigs != null ? !this.IndexConfigs.equals(that.IndexConfigs) : that.IndexConfigs != null) {
            return false;
        }
        if (this.InsecureRegistryCIDRs != null ? !this.InsecureRegistryCIDRs.equals(that.InsecureRegistryCIDRs) : that.InsecureRegistryCIDRs != null) {
            return false;
        }
        return !(this.Mirrors != null ? !this.Mirrors.equals(that.Mirrors) : that.Mirrors != null);
    }

    public class InsecureRegistryCIDRsNestedImpl<N>
    extends NetIPNetFluentImpl<ServiceConfigFluent.InsecureRegistryCIDRsNested<N>>
    implements ServiceConfigFluent.InsecureRegistryCIDRsNested<N>,
    Nested<N> {
        private final NetIPNetBuilder builder;
        private final int index;

        InsecureRegistryCIDRsNestedImpl(int index, NetIPNet item) {
            this.index = index;
            this.builder = new NetIPNetBuilder(this, item);
        }

        InsecureRegistryCIDRsNestedImpl() {
            this.index = -1;
            this.builder = new NetIPNetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceConfigFluentImpl.this.setToInsecureRegistryCIDRs(this.index, this.builder.build());
        }

        @Override
        public N endInsecureRegistryCIDR() {
            return this.and();
        }
    }
}

