/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.ValidationUtils;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditablePort;
import io.fabric8.docker.api.model.Port;
import io.fabric8.docker.api.model.PortFluent;
import io.fabric8.docker.api.model.PortFluentImpl;

public class PortBuilder
extends PortFluentImpl<PortBuilder>
implements VisitableBuilder<Port, PortBuilder> {
    PortFluent<?> fluent;
    Boolean validationEnabled;

    public PortBuilder() {
        this(true);
    }

    public PortBuilder(Boolean validationEnabled) {
        this(new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PortBuilder(PortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance) {
        this(fluent, instance, true);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIP(instance.getIP());
        fluent.withPrivatePort(instance.getPrivatePort());
        fluent.withPublicPort(instance.getPublicPort());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public PortBuilder(Port instance) {
        this(instance, (Boolean)true);
    }

    public PortBuilder(Port instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIP(instance.getIP());
        this.withPrivatePort(instance.getPrivatePort());
        this.withPublicPort(instance.getPublicPort());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditablePort build() {
        EditablePort buildable = new EditablePort(this.fluent.getIP(), this.fluent.getPrivatePort(), this.fluent.getPublicPort(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBuilder that = (PortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

