/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Predicate;
import io.fabric8.docker.api.model.Address;
import io.fabric8.docker.api.model.AddressBuilder;
import io.fabric8.docker.api.model.AddressFluentImpl;
import io.fabric8.docker.api.model.EndpointSettings;
import io.fabric8.docker.api.model.NetworkSettings;
import io.fabric8.docker.api.model.NetworkSettingsFluent;
import io.fabric8.docker.api.model.PortBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NetworkSettingsFluentImpl<A extends NetworkSettingsFluent<A>>
extends BaseFluent<A>
implements NetworkSettingsFluent<A> {
    private String EndpointID;
    private String Gateway;
    private String GlobalIPv6Address;
    private Integer GlobalIPv6PrefixLen;
    private String IPAddress;
    private Integer IPPrefixLen;
    private String IPv6Gateway;
    private String MacAddress;
    private String Bridge;
    private String SandboxID;
    private Boolean HairpinMode;
    private String LinkLocalIPv6Address;
    private Integer LinkLocalIPv6PrefixLen;
    private Map<String, ArrayList<PortBinding>> Ports = new LinkedHashMap<String, ArrayList<PortBinding>>();
    private String SandboxKey;
    private List<AddressBuilder> SecondaryIPAddresses = new ArrayList<AddressBuilder>();
    private List<AddressBuilder> SecondaryIPv6Addresses = new ArrayList<AddressBuilder>();
    private Map<String, EndpointSettings> Networks = new LinkedHashMap<String, EndpointSettings>();

    public NetworkSettingsFluentImpl() {
    }

    public NetworkSettingsFluentImpl(NetworkSettings instance) {
        this.withEndpointID(instance.getEndpointID());
        this.withGateway(instance.getGateway());
        this.withGlobalIPv6Address(instance.getGlobalIPv6Address());
        this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen());
        this.withIPAddress(instance.getIPAddress());
        this.withIPPrefixLen(instance.getIPPrefixLen());
        this.withIPv6Gateway(instance.getIPv6Gateway());
        this.withMacAddress(instance.getMacAddress());
        this.withBridge(instance.getBridge());
        this.withSandboxID(instance.getSandboxID());
        this.withHairpinMode(instance.getHairpinMode());
        this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        this.withPorts(instance.getPorts());
        this.withSandboxKey(instance.getSandboxKey());
        this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
        this.withNetworks(instance.getNetworks());
    }

    @Override
    public String getEndpointID() {
        return this.EndpointID;
    }

    @Override
    public A withEndpointID(String EndpointID) {
        this.EndpointID = EndpointID;
        return (A)this;
    }

    @Override
    public Boolean hasEndpointID() {
        return this.EndpointID != null;
    }

    @Override
    public String getGateway() {
        return this.Gateway;
    }

    @Override
    public A withGateway(String Gateway) {
        this.Gateway = Gateway;
        return (A)this;
    }

    @Override
    public Boolean hasGateway() {
        return this.Gateway != null;
    }

    @Override
    public String getGlobalIPv6Address() {
        return this.GlobalIPv6Address;
    }

    @Override
    public A withGlobalIPv6Address(String GlobalIPv6Address) {
        this.GlobalIPv6Address = GlobalIPv6Address;
        return (A)this;
    }

    @Override
    public Boolean hasGlobalIPv6Address() {
        return this.GlobalIPv6Address != null;
    }

    @Override
    public Integer getGlobalIPv6PrefixLen() {
        return this.GlobalIPv6PrefixLen;
    }

    @Override
    public A withGlobalIPv6PrefixLen(Integer GlobalIPv6PrefixLen) {
        this.GlobalIPv6PrefixLen = GlobalIPv6PrefixLen;
        return (A)this;
    }

    @Override
    public Boolean hasGlobalIPv6PrefixLen() {
        return this.GlobalIPv6PrefixLen != null;
    }

    @Override
    public String getIPAddress() {
        return this.IPAddress;
    }

    @Override
    public A withIPAddress(String IPAddress) {
        this.IPAddress = IPAddress;
        return (A)this;
    }

    @Override
    public Boolean hasIPAddress() {
        return this.IPAddress != null;
    }

    @Override
    public Integer getIPPrefixLen() {
        return this.IPPrefixLen;
    }

    @Override
    public A withIPPrefixLen(Integer IPPrefixLen) {
        this.IPPrefixLen = IPPrefixLen;
        return (A)this;
    }

    @Override
    public Boolean hasIPPrefixLen() {
        return this.IPPrefixLen != null;
    }

    @Override
    public String getIPv6Gateway() {
        return this.IPv6Gateway;
    }

    @Override
    public A withIPv6Gateway(String IPv6Gateway) {
        this.IPv6Gateway = IPv6Gateway;
        return (A)this;
    }

    @Override
    public Boolean hasIPv6Gateway() {
        return this.IPv6Gateway != null;
    }

    @Override
    public String getMacAddress() {
        return this.MacAddress;
    }

    @Override
    public A withMacAddress(String MacAddress) {
        this.MacAddress = MacAddress;
        return (A)this;
    }

    @Override
    public Boolean hasMacAddress() {
        return this.MacAddress != null;
    }

    @Override
    public String getBridge() {
        return this.Bridge;
    }

    @Override
    public A withBridge(String Bridge) {
        this.Bridge = Bridge;
        return (A)this;
    }

    @Override
    public Boolean hasBridge() {
        return this.Bridge != null;
    }

    @Override
    public String getSandboxID() {
        return this.SandboxID;
    }

    @Override
    public A withSandboxID(String SandboxID) {
        this.SandboxID = SandboxID;
        return (A)this;
    }

    @Override
    public Boolean hasSandboxID() {
        return this.SandboxID != null;
    }

    @Override
    public Boolean isHairpinMode() {
        return this.HairpinMode;
    }

    @Override
    public A withHairpinMode(Boolean HairpinMode) {
        this.HairpinMode = HairpinMode;
        return (A)this;
    }

    @Override
    public Boolean hasHairpinMode() {
        return this.HairpinMode != null;
    }

    @Override
    public String getLinkLocalIPv6Address() {
        return this.LinkLocalIPv6Address;
    }

    @Override
    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address) {
        this.LinkLocalIPv6Address = LinkLocalIPv6Address;
        return (A)this;
    }

    @Override
    public Boolean hasLinkLocalIPv6Address() {
        return this.LinkLocalIPv6Address != null;
    }

    @Override
    public Integer getLinkLocalIPv6PrefixLen() {
        return this.LinkLocalIPv6PrefixLen;
    }

    @Override
    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen) {
        this.LinkLocalIPv6PrefixLen = LinkLocalIPv6PrefixLen;
        return (A)this;
    }

    @Override
    public Boolean hasLinkLocalIPv6PrefixLen() {
        return this.LinkLocalIPv6PrefixLen != null;
    }

    @Override
    public A addToPorts(String key, ArrayList<PortBinding> value) {
        if (key != null && value != null) {
            this.Ports.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            this.Ports.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(String key) {
        if (key != null) {
            this.Ports.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Ports.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<PortBinding>> getPorts() {
        return this.Ports;
    }

    @Override
    public A withPorts(Map<String, ArrayList<PortBinding>> Ports) {
        this.Ports.clear();
        if (Ports != null) {
            this.Ports.putAll(Ports);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.Ports != null;
    }

    @Override
    public String getSandboxKey() {
        return this.SandboxKey;
    }

    @Override
    public A withSandboxKey(String SandboxKey) {
        this.SandboxKey = SandboxKey;
        return (A)this;
    }

    @Override
    public Boolean hasSandboxKey() {
        return this.SandboxKey != null;
    }

    @Override
    public A addToSecondaryIPAddresses(int index, Address item) {
        AddressBuilder builder = new AddressBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.SecondaryIPAddresses.add(index >= 0 ? index : this.SecondaryIPAddresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecondaryIPAddresses(int index, Address item) {
        AddressBuilder builder = new AddressBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.SecondaryIPAddresses.size()) {
            this.SecondaryIPAddresses.add(builder);
        } else {
            this.SecondaryIPAddresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecondaryIPAddresses(Collection<Address> items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecondaryIPAddresses(Collection<Address> items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Address> getSecondaryIPAddresses() {
        return NetworkSettingsFluentImpl.build(this.SecondaryIPAddresses);
    }

    @Override
    public List<Address> buildSecondaryIPAddresses() {
        return NetworkSettingsFluentImpl.build(this.SecondaryIPAddresses);
    }

    @Override
    public Address buildSecondaryIPAddress(int index) {
        return this.SecondaryIPAddresses.get(index).build();
    }

    @Override
    public Address buildFirstSecondaryIPAddress() {
        return this.SecondaryIPAddresses.get(0).build();
    }

    @Override
    public Address buildLastSecondaryIPAddress() {
        return this.SecondaryIPAddresses.get(this.SecondaryIPAddresses.size() - 1).build();
    }

    @Override
    public Address buildMatchingSecondaryIPAddress(Predicate<AddressBuilder> predicate) {
        for (AddressBuilder item : this.SecondaryIPAddresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses) {
        this._visitables.removeAll(this.SecondaryIPAddresses);
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecondaryIPAddresses(Address ... SecondaryIPAddresses) {
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecondaryIPAddresses() {
        return this.SecondaryIPAddresses != null && !this.SecondaryIPAddresses.isEmpty();
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress() {
        return new SecondaryIPAddressesNestedImpl();
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item) {
        return new SecondaryIPAddressesNestedImpl(-1, item);
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> setNewSecondaryIPAddressLike(int index, Address item) {
        return new SecondaryIPAddressesNestedImpl(index, item);
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editSecondaryIPAddress(int index) {
        if (this.SecondaryIPAddresses.size() <= index) {
            throw new RuntimeException("Can't edit SecondaryIPAddresses. Index exceeds size.");
        }
        return this.setNewSecondaryIPAddressLike(index, this.buildSecondaryIPAddress(index));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editFirstSecondaryIPAddress() {
        if (this.SecondaryIPAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first SecondaryIPAddresses. The list is empty.");
        }
        return this.setNewSecondaryIPAddressLike(0, this.buildSecondaryIPAddress(0));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editLastSecondaryIPAddress() {
        int index = this.SecondaryIPAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last SecondaryIPAddresses. The list is empty.");
        }
        return this.setNewSecondaryIPAddressLike(index, this.buildSecondaryIPAddress(index));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPAddressesNested<A> editMatchingSecondaryIPAddress(Predicate<AddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.SecondaryIPAddresses.size(); ++i) {
            if (!predicate.apply(this.SecondaryIPAddresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching SecondaryIPAddresses. No match found.");
        }
        return this.setNewSecondaryIPAddressLike(index, this.buildSecondaryIPAddress(index));
    }

    @Override
    public A addNewSecondaryIPAddress(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }

    @Override
    public A addToSecondaryIPv6Addresses(int index, Address item) {
        AddressBuilder builder = new AddressBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.SecondaryIPv6Addresses.add(index >= 0 ? index : this.SecondaryIPv6Addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecondaryIPv6Addresses(int index, Address item) {
        AddressBuilder builder = new AddressBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.SecondaryIPv6Addresses.size()) {
            this.SecondaryIPv6Addresses.add(builder);
        } else {
            this.SecondaryIPv6Addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPv6Addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecondaryIPv6Addresses(Collection<Address> items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPv6Addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPv6Addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecondaryIPv6Addresses(Collection<Address> items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPv6Addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Address> getSecondaryIPv6Addresses() {
        return NetworkSettingsFluentImpl.build(this.SecondaryIPv6Addresses);
    }

    @Override
    public List<Address> buildSecondaryIPv6Addresses() {
        return NetworkSettingsFluentImpl.build(this.SecondaryIPv6Addresses);
    }

    @Override
    public Address buildSecondaryIPv6Address(int index) {
        return this.SecondaryIPv6Addresses.get(index).build();
    }

    @Override
    public Address buildFirstSecondaryIPv6Address() {
        return this.SecondaryIPv6Addresses.get(0).build();
    }

    @Override
    public Address buildLastSecondaryIPv6Address() {
        return this.SecondaryIPv6Addresses.get(this.SecondaryIPv6Addresses.size() - 1).build();
    }

    @Override
    public Address buildMatchingSecondaryIPv6Address(Predicate<AddressBuilder> predicate) {
        for (AddressBuilder item : this.SecondaryIPv6Addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses) {
        this._visitables.removeAll(this.SecondaryIPv6Addresses);
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecondaryIPv6Addresses(Address ... SecondaryIPv6Addresses) {
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecondaryIPv6Addresses() {
        return this.SecondaryIPv6Addresses != null && !this.SecondaryIPv6Addresses.isEmpty();
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address() {
        return new SecondaryIPv6AddressesNestedImpl();
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item) {
        return new SecondaryIPv6AddressesNestedImpl(-1, item);
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> setNewSecondaryIPv6AddressLike(int index, Address item) {
        return new SecondaryIPv6AddressesNestedImpl(index, item);
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editSecondaryIPv6Address(int index) {
        if (this.SecondaryIPv6Addresses.size() <= index) {
            throw new RuntimeException("Can't edit SecondaryIPv6Addresses. Index exceeds size.");
        }
        return this.setNewSecondaryIPv6AddressLike(index, this.buildSecondaryIPv6Address(index));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editFirstSecondaryIPv6Address() {
        if (this.SecondaryIPv6Addresses.size() == 0) {
            throw new RuntimeException("Can't edit first SecondaryIPv6Addresses. The list is empty.");
        }
        return this.setNewSecondaryIPv6AddressLike(0, this.buildSecondaryIPv6Address(0));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editLastSecondaryIPv6Address() {
        int index = this.SecondaryIPv6Addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last SecondaryIPv6Addresses. The list is empty.");
        }
        return this.setNewSecondaryIPv6AddressLike(index, this.buildSecondaryIPv6Address(index));
    }

    @Override
    public NetworkSettingsFluent.SecondaryIPv6AddressesNested<A> editMatchingSecondaryIPv6Address(Predicate<AddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.SecondaryIPv6Addresses.size(); ++i) {
            if (!predicate.apply(this.SecondaryIPv6Addresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching SecondaryIPv6Addresses. No match found.");
        }
        return this.setNewSecondaryIPv6AddressLike(index, this.buildSecondaryIPv6Address(index));
    }

    @Override
    public A addNewSecondaryIPv6Address(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }

    @Override
    public A addToNetworks(String key, EndpointSettings value) {
        if (key != null && value != null) {
            this.Networks.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNetworks(Map<String, EndpointSettings> map) {
        if (map != null) {
            this.Networks.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNetworks(String key) {
        if (key != null) {
            this.Networks.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNetworks(Map<String, EndpointSettings> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Networks.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, EndpointSettings> getNetworks() {
        return this.Networks;
    }

    @Override
    public A withNetworks(Map<String, EndpointSettings> Networks) {
        this.Networks.clear();
        if (Networks != null) {
            this.Networks.putAll(Networks);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworks() {
        return this.Networks != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSettingsFluentImpl that = (NetworkSettingsFluentImpl)o;
        if (this.EndpointID != null ? !this.EndpointID.equals(that.EndpointID) : that.EndpointID != null) {
            return false;
        }
        if (this.Gateway != null ? !this.Gateway.equals(that.Gateway) : that.Gateway != null) {
            return false;
        }
        if (this.GlobalIPv6Address != null ? !this.GlobalIPv6Address.equals(that.GlobalIPv6Address) : that.GlobalIPv6Address != null) {
            return false;
        }
        if (this.GlobalIPv6PrefixLen != null ? !this.GlobalIPv6PrefixLen.equals(that.GlobalIPv6PrefixLen) : that.GlobalIPv6PrefixLen != null) {
            return false;
        }
        if (this.IPAddress != null ? !this.IPAddress.equals(that.IPAddress) : that.IPAddress != null) {
            return false;
        }
        if (this.IPPrefixLen != null ? !this.IPPrefixLen.equals(that.IPPrefixLen) : that.IPPrefixLen != null) {
            return false;
        }
        if (this.IPv6Gateway != null ? !this.IPv6Gateway.equals(that.IPv6Gateway) : that.IPv6Gateway != null) {
            return false;
        }
        if (this.MacAddress != null ? !this.MacAddress.equals(that.MacAddress) : that.MacAddress != null) {
            return false;
        }
        if (this.Bridge != null ? !this.Bridge.equals(that.Bridge) : that.Bridge != null) {
            return false;
        }
        if (this.SandboxID != null ? !this.SandboxID.equals(that.SandboxID) : that.SandboxID != null) {
            return false;
        }
        if (this.HairpinMode != null ? !this.HairpinMode.equals(that.HairpinMode) : that.HairpinMode != null) {
            return false;
        }
        if (this.LinkLocalIPv6Address != null ? !this.LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) : that.LinkLocalIPv6Address != null) {
            return false;
        }
        if (this.LinkLocalIPv6PrefixLen != null ? !this.LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) : that.LinkLocalIPv6PrefixLen != null) {
            return false;
        }
        if (this.Ports != null ? !this.Ports.equals(that.Ports) : that.Ports != null) {
            return false;
        }
        if (this.SandboxKey != null ? !this.SandboxKey.equals(that.SandboxKey) : that.SandboxKey != null) {
            return false;
        }
        if (this.SecondaryIPAddresses != null ? !this.SecondaryIPAddresses.equals(that.SecondaryIPAddresses) : that.SecondaryIPAddresses != null) {
            return false;
        }
        if (this.SecondaryIPv6Addresses != null ? !this.SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) : that.SecondaryIPv6Addresses != null) {
            return false;
        }
        return !(this.Networks != null ? !this.Networks.equals(that.Networks) : that.Networks != null);
    }

    public class SecondaryIPv6AddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsFluent.SecondaryIPv6AddressesNested<N>>
    implements NetworkSettingsFluent.SecondaryIPv6AddressesNested<N>,
    Nested<N> {
        private final AddressBuilder builder;
        private final int index;

        SecondaryIPv6AddressesNestedImpl(int index, Address item) {
            this.index = index;
            this.builder = new AddressBuilder(this, item);
        }

        SecondaryIPv6AddressesNestedImpl() {
            this.index = -1;
            this.builder = new AddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSettingsFluentImpl.this.setToSecondaryIPv6Addresses(this.index, this.builder.build());
        }

        @Override
        public N endSecondaryIPv6Address() {
            return this.and();
        }
    }

    public class SecondaryIPAddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsFluent.SecondaryIPAddressesNested<N>>
    implements NetworkSettingsFluent.SecondaryIPAddressesNested<N>,
    Nested<N> {
        private final AddressBuilder builder;
        private final int index;

        SecondaryIPAddressesNestedImpl(int index, Address item) {
            this.index = index;
            this.builder = new AddressBuilder(this, item);
        }

        SecondaryIPAddressesNestedImpl() {
            this.index = -1;
            this.builder = new AddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkSettingsFluentImpl.this.setToSecondaryIPAddresses(this.index, this.builder.build());
        }

        @Override
        public N endSecondaryIPAddress() {
            return this.and();
        }
    }
}

